/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitFactory;
import net.citizensnpcs.api.trait.TraitManager;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.trait.waypoint.Waypoints;

public class CitizensTraitManager
implements TraitManager {
    private final Map<String, Class<? extends Trait>> registered = new HashMap<String, Class<? extends Trait>>();
    private final Map<Class<? extends Trait>, Constructor<? extends Trait>> CACHED_CTORS = new HashMap<Class<? extends Trait>, Constructor<? extends Trait>>();

    public CitizensTraitManager() {
        this.registerTrait(new TraitFactory(Equipment.class).withName("equipment"));
        this.registerTrait(new TraitFactory(Inventory.class).withName("inventory"));
        this.registerTrait(new TraitFactory(LookClose.class).withName("look-close"));
        this.registerTrait(new TraitFactory(MobType.class).withName("type"));
        this.registerTrait(new TraitFactory(Owner.class).withName("owner"));
        this.registerTrait(new TraitFactory(Powered.class).withName("powered"));
        this.registerTrait(new TraitFactory(Spawned.class).withName("spawned"));
        this.registerTrait(new TraitFactory(CurrentLocation.class).withName("location"));
        this.registerTrait(new TraitFactory(Text.class).withName("text"));
        this.registerTrait(new TraitFactory(Waypoints.class).withName("waypoints"));
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        return this.getTrait(clazz, null);
    }

    @Override
    public <T extends Trait> T getTrait(String name) {
        if (!this.registered.containsKey(name)) {
            return null;
        }
        return (T)this.create(this.registered.get(name), null);
    }

    @Override
    public void registerTrait(TraitFactory factory) {
        this.registered.put(factory.getName(), factory.getTraitClass());
    }

    public <T extends Trait> T getTrait(Class<T> clazz, NPC npc) {
        for (Map.Entry<String, Class<? extends Trait>> entry : this.registered.entrySet()) {
            if (!entry.getValue().equals(clazz)) continue;
            Trait t = this.create(entry.getValue(), npc);
            t.setName(entry.getKey());
            return (T)t;
        }
        return null;
    }

    public <T extends Trait> T getTrait(String name, NPC npc) {
        Class<? extends Trait> clazz = this.registered.get(name);
        if (clazz == null) {
            return null;
        }
        Trait t = this.getTrait(clazz, npc);
        return (T)t;
    }

    private <T extends Trait> T create(Class<T> trait, NPC npc) {
        Constructor<Trait> constructor;
        if (!this.CACHED_CTORS.containsKey(trait)) {
            try {
                constructor = trait.getConstructor(NPC.class);
                constructor.setAccessible(true);
            }
            catch (Exception ex) {
                constructor = null;
            }
            this.CACHED_CTORS.put(trait, constructor);
        } else {
            constructor = this.CACHED_CTORS.get(trait);
        }
        try {
            if (constructor == null || npc == null) {
                return (T)((Trait)trait.newInstance());
            }
            return (T)constructor.newInstance(npc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

