/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.base.Throwables;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.citizensnpcs.NPCNeedsRespawnEvent;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.SwimmingExaminer;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.event.NPCTeleportEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.npc.EntityController;
import net.citizensnpcs.npc.EntityControllers;
import net.citizensnpcs.npc.ai.CitizensNavigator;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.AttributeTrait;
import net.citizensnpcs.trait.ChunkTicketTrait;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.HologramTrait;
import net.citizensnpcs.trait.PacketNPC;
import net.citizensnpcs.trait.ScoreboardTrait;
import net.citizensnpcs.trait.SitTrait;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SneakTrait;
import net.citizensnpcs.util.ChunkCoord;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import net.citizensnpcs.util.PlayerUpdateTask;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.scheduler.BukkitRunnable;

public class CitizensNPC
extends AbstractNPC {
    private ChunkCoord cachedCoord;
    private EntityController entityController;
    private final CitizensNavigator navigator = new CitizensNavigator(this);
    private int updateCounter = 0;
    private static final SetMultimap<ChunkCoord, NPC> CHUNK_LOADERS = HashMultimap.create();
    private static boolean SUPPORT_ATTRIBUTES = false;
    private static boolean SUPPORT_GLOWING = false;
    private static boolean SUPPORT_PICKUP_ITEMS = false;
    private static boolean SUPPORT_SILENT = false;
    private static boolean SUPPORT_USE_ITEM = true;

    public CitizensNPC(UUID uuid, int id, String name, EntityController controller, NPCRegistry registry) {
        super(uuid, id, name, registry);
        this.setEntityController(controller);
        this.addTrait(ChunkTicketTrait.class);
    }

    @Override
    public boolean despawn(DespawnReason reason) {
        if (reason == DespawnReason.RELOAD) {
            for (Trait trait : this.traits.values()) {
                HandlerList.unregisterAll((Listener)trait);
            }
        }
        if (this.getEntity() == null && reason != DespawnReason.DEATH) {
            Messaging.debug("Tried to despawn", this, "while already despawned, DespawnReason." + (Object)((Object)reason));
            return true;
        }
        NPCDespawnEvent event = new NPCDespawnEvent((NPC)this, reason);
        if (reason == DespawnReason.CHUNK_UNLOAD) {
            event.setCancelled(this.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())));
        }
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && reason != DespawnReason.DEATH) {
            Messaging.debug("Couldn't despawn", this, "due to despawn event cancellation. Will load chunk.", this.getEntity().isValid(), ", DespawnReason." + (Object)((Object)reason));
            return false;
        }
        boolean keepSelected = this.getOrAddTrait(Spawned.class).shouldSpawn();
        if (!keepSelected) {
            this.data().remove("selectors");
        }
        if (this.getEntity() instanceof Player) {
            PlayerUpdateTask.deregister(this.getEntity());
        }
        this.navigator.onDespawn();
        for (Trait trait : new ArrayList(this.traits.values())) {
            trait.onDespawn(reason);
        }
        Messaging.debug("Despawned", this, "DespawnReason." + (Object)((Object)reason));
        if (reason == DespawnReason.DEATH) {
            this.entityController.die();
        } else {
            this.entityController.remove();
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.resetCachedCoord();
    }

    @Override
    public void faceLocation(Location location) {
        if (!this.isSpawned()) {
            return;
        }
        Util.faceLocation(this.getEntity(), location);
    }

    @Override
    public BlockBreaker getBlockBreaker(Block targetBlock, BlockBreaker.BlockBreakerConfiguration config) {
        return NMS.getBlockBreaker(this.getEntity(), targetBlock, config);
    }

    @Override
    public Entity getEntity() {
        return this.entityController == null ? null : this.entityController.getBukkitEntity();
    }

    public EntityController getEntityController() {
        return this.entityController;
    }

    @Override
    public Navigator getNavigator() {
        return this.navigator;
    }

    @Override
    public Location getStoredLocation() {
        return this.isSpawned() ? this.getEntity().getLocation() : this.getOrAddTrait(CurrentLocation.class).getLocation();
    }

    @Override
    public boolean isFlyable() {
        this.updateFlyableState();
        return super.isFlyable();
    }

    @Override
    public boolean isSpawned() {
        return this.getEntity() != null && (this.hasTrait(PacketNPC.class) || NMS.isValid(this.getEntity()));
    }

    @Override
    public boolean isUpdating(NPC.NPCUpdate update) {
        return update == NPC.NPCUpdate.PACKET ? this.updateCounter > this.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asTicks())) : false;
    }

    @Override
    public void load(DataKey root) {
        super.load(root);
        if (this.getOrAddTrait(Spawned.class).shouldSpawn()) {
            CurrentLocation current = this.getOrAddTrait(CurrentLocation.class);
            if (current.getLocation() != null) {
                this.spawn(current.getLocation(), SpawnReason.RESPAWN);
            } else if (current.getChunkCoord() != null) {
                Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent((NPC)this, current.getChunkCoord()));
            }
        }
        this.navigator.load(root.getRelative("navigator"));
    }

    @Override
    public boolean requiresNameHologram() {
        return !this.data().has(NPC.Metadata.HOLOGRAM_RENDERER) && (super.requiresNameHologram() || Settings.Setting.ALWAYS_USE_NAME_HOLOGRAM.asBoolean());
    }

    private void resetCachedCoord() {
        if (this.cachedCoord == null) {
            return;
        }
        Set npcs = CHUNK_LOADERS.get((Object)this.cachedCoord);
        npcs.remove(this);
        if (npcs.size() == 0) {
            this.cachedCoord.setForceLoaded(false);
        }
        this.cachedCoord = null;
    }

    @Override
    public void save(DataKey root) {
        super.save(root);
        if (!this.data().get(NPC.Metadata.SHOULD_SAVE, Boolean.valueOf(true)).booleanValue()) {
            return;
        }
        this.navigator.save(root.getRelative("navigator"));
    }

    @Override
    public void scheduleUpdate(NPC.NPCUpdate update) {
        if (update == NPC.NPCUpdate.PACKET) {
            this.updateCounter = this.data().get(NPC.Metadata.PACKET_UPDATE_DELAY, Integer.valueOf(Settings.Setting.PACKET_UPDATE_DELAY.asTicks())) + 1;
        }
    }

    @Override
    public void setBukkitEntityType(EntityType type) {
        EntityController controller = EntityControllers.createForType(type);
        if (controller == null) {
            throw new IllegalArgumentException("Unsupported entity type " + type);
        }
        this.setEntityController(controller);
    }

    public void setEntityController(EntityController newController) {
        PacketNPC packet;
        Objects.requireNonNull(newController);
        boolean wasSpawned = this.entityController == null ? false : this.isSpawned();
        Location prev = null;
        if (wasSpawned) {
            prev = this.getEntity().getLocation();
            this.despawn(DespawnReason.PENDING_RESPAWN);
        }
        if ((packet = this.getTraitNullable(PacketNPC.class)) != null) {
            newController = packet.wrap(newController);
        }
        this.entityController = newController;
        if (wasSpawned) {
            this.spawn(prev, SpawnReason.RESPAWN);
        }
    }

    @Override
    public void setFlyable(boolean flyable) {
        super.setFlyable(flyable);
        this.updateFlyableState();
    }

    @Override
    public void setMoveDestination(Location destination) {
        if (!this.isSpawned()) {
            return;
        }
        if (destination == null) {
            NMS.cancelMoveDestination(this.getEntity());
        } else {
            NMS.setDestination(this.getEntity(), destination.getX(), destination.getY(), destination.getZ(), this.getNavigator().getDefaultParameters().speedModifier());
        }
    }

    @Override
    protected void setNameInternal(String name) {
        HologramTrait.HologramRenderer hr;
        super.setNameInternal(name);
        if (this.requiresNameHologram() && (hr = this.getOrAddTrait(HologramTrait.class).getNameRenderer()) != null) {
            hr.updateText(this, this.getRawName());
        }
        this.updateCustomName();
    }

    @Override
    public void setSneaking(boolean sneaking) {
        this.getOrAddTrait(SneakTrait.class).setSneaking(sneaking);
    }

    @Override
    public boolean shouldRemoveFromPlayerList() {
        return this.data().get(NPC.Metadata.REMOVE_FROM_PLAYERLIST, Boolean.valueOf(Settings.Setting.REMOVE_PLAYERS_FROM_PLAYER_LIST.asBoolean()));
    }

    @Override
    public boolean shouldRemoveFromTabList() {
        return this.data().get(NPC.Metadata.REMOVE_FROM_TABLIST, Boolean.valueOf(Settings.Setting.DISABLE_TABLIST.asBoolean()));
    }

    @Override
    public boolean spawn(Location at, final SpawnReason reason, final Consumer<Entity> callback) {
        Objects.requireNonNull(at, "location cannot be null");
        Objects.requireNonNull(reason, "reason cannot be null");
        if (this.getEntity() != null) {
            Messaging.debug("Tried to spawn", this, "while already spawned. SpawnReason." + (Object)((Object)reason));
            return false;
        }
        if (at.getWorld() == null) {
            Messaging.debug("Tried to spawn", this, "but the world was null. SpawnReason." + (Object)((Object)reason));
            return false;
        }
        at = at.clone();
        if (reason == SpawnReason.CHUNK_LOAD || reason == SpawnReason.COMMAND) {
            at.getChunk().load();
        }
        this.getOrAddTrait(CurrentLocation.class).setLocation(at);
        this.entityController.create(at.clone(), this);
        if (this.getEntity() instanceof SkinnableEntity && !this.hasTrait(SkinLayers.class)) {
            ((SkinnableEntity)this.getEntity()).setSkinFlags(EnumSet.allOf(SkinLayers.Layer.class));
        }
        for (Trait trait : this.traits.values().toArray(new Trait[this.traits.values().size()])) {
            try {
                trait.onPreSpawn();
            }
            catch (Throwable ex) {
                Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), this.getId());
                ex.printStackTrace();
            }
        }
        this.data().set(NPC.Metadata.NPC_SPAWNING_IN_PROGRESS, (Object)true);
        boolean wasLoaded = Messaging.isDebugging() ? Util.isLoaded(at) : false;
        boolean couldSpawn = this.entityController.spawn(at);
        if (!couldSpawn) {
            if (Messaging.isDebugging()) {
                Messaging.debug("Retrying spawn of", this, "later, SpawnReason." + (Object)((Object)reason) + ". Was loaded", wasLoaded, "is loaded", Util.isLoaded(at));
            }
            this.entityController.remove();
            Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent((NPC)this, at));
            this.data().remove(NPC.Metadata.NPC_SPAWNING_IN_PROGRESS);
            return false;
        }
        NMS.setLocationDirectly(this.getEntity(), at);
        NMS.setHeadAndBodyYaw(this.getEntity(), at.getYaw());
        final Location to = at;
        final Consumer<Runnable> postSpawn = new Consumer<Runnable>(){
            private int timer;

            @Override
            public void accept(Runnable cancel) {
                if (CitizensNPC.this.getEntity() == null || !CitizensNPC.this.hasTrait(PacketNPC.class) && !CitizensNPC.this.getEntity().isValid()) {
                    if (this.timer++ > Settings.Setting.ENTITY_SPAWN_WAIT_DURATION.asTicks()) {
                        Messaging.debug("Couldn't spawn ", CitizensNPC.this, "waited", this.timer, "ticks but entity not added to world");
                        CitizensNPC.this.entityController.remove();
                        cancel.run();
                        Bukkit.getPluginManager().callEvent((Event)new NPCNeedsRespawnEvent((NPC)CitizensNPC.this, to));
                    }
                    return;
                }
                CitizensNPC.this.getOrAddTrait(CurrentLocation.class).setLocation(to);
                CitizensNPC.this.getOrAddTrait(Spawned.class).setSpawned(true);
                NPCSpawnEvent spawnEvent = new NPCSpawnEvent(CitizensNPC.this, to, reason);
                Bukkit.getPluginManager().callEvent((Event)spawnEvent);
                if (spawnEvent.isCancelled()) {
                    Messaging.debug("Couldn't spawn", CitizensNPC.this, "SpawnReason." + (Object)((Object)reason), "due to event cancellation.");
                    CitizensNPC.this.entityController.remove();
                    cancel.run();
                    return;
                }
                CitizensNPC.this.navigator.onSpawn();
                for (Trait trait : CitizensNPC.this.traits.values().toArray((Trait[])ObjectArrays.newArray(Trait.class, (int)CitizensNPC.this.traits.size()))) {
                    try {
                        trait.onSpawn();
                    }
                    catch (Throwable ex) {
                        Messaging.severeTr("citizens.notifications.trait-onspawn-failed", trait.getName(), CitizensNPC.this.getId());
                        ex.printStackTrace();
                    }
                }
                NMS.replaceTracker(CitizensNPC.this.getEntity());
                CitizensNPC.this.data().remove(NPC.Metadata.NPC_SPAWNING_IN_PROGRESS);
                EntityType type = CitizensNPC.this.getEntity().getType();
                if (type.isAlive()) {
                    LivingEntity entity = (LivingEntity)CitizensNPC.this.getEntity();
                    entity.setRemoveWhenFarAway(false);
                    if ((type == EntityType.PLAYER || Util.isHorse(type)) && (SUPPORT_ATTRIBUTES && !CitizensNPC.this.hasTrait(AttributeTrait.class) || !CitizensNPC.this.getTrait(AttributeTrait.class).hasAttribute((Attribute)Util.getRegistryValue(Registry.ATTRIBUTE, "generic.step_height", "step_height")))) {
                        NMS.setStepHeight((Entity)entity, 1.0f);
                    }
                    if (type == EntityType.PLAYER) {
                        AttributeTrait attr;
                        PlayerUpdateTask.register(CitizensNPC.this.getEntity());
                        if (SUPPORT_ATTRIBUTES && Util.getRegistryValue(Registry.ATTRIBUTE, "waypoint_transmit_range") != null && !(attr = CitizensNPC.this.getOrAddTrait(AttributeTrait.class)).hasAttribute(Attribute.WAYPOINT_TRANSMIT_RANGE)) {
                            attr.setAttributeValue(Attribute.WAYPOINT_TRANSMIT_RANGE, 0.0);
                        }
                    }
                    entity.setNoDamageTicks(CitizensNPC.this.data().get(NPC.Metadata.SPAWN_NODAMAGE_TICKS, Integer.valueOf(Settings.Setting.DEFAULT_SPAWN_NODAMAGE_DURATION.asTicks())).intValue());
                }
                if (CitizensNPC.this.requiresNameHologram() && !CitizensNPC.this.hasTrait(HologramTrait.class)) {
                    CitizensNPC.this.addTrait(HologramTrait.class);
                }
                CitizensNPC.this.updateFlyableState();
                CitizensNPC.this.updateCustomNameVisibility();
                CitizensNPC.this.updateScoreboard();
                Messaging.debug("Spawned", CitizensNPC.this, "SpawnReason." + (Object)((Object)reason));
                cancel.run();
                if (callback != null) {
                    callback.accept(CitizensNPC.this.getEntity());
                }
            }
        };
        if (this.getEntity() != null && this.getEntity().isValid()) {
            postSpawn.accept(() -> {});
        } else {
            new BukkitRunnable(){

                public void run() {
                    postSpawn.accept(() -> (this).cancel());
                }
            }.runTaskTimer(CitizensAPI.getPlugin(), 0L, 1L);
        }
        return true;
    }

    @Override
    public void teleport(Location location, PlayerTeleportEvent.TeleportCause reason) {
        if (!this.isSpawned()) {
            return;
        }
        if (this.hasTrait(SitTrait.class) && this.getOrAddTrait(SitTrait.class).isSitting()) {
            this.getOrAddTrait(SitTrait.class).setSitting(location);
        }
        Location npcLoc = this.getEntity().getLocation();
        if (this.isSpawned() && npcLoc.getWorld() == location.getWorld()) {
            if (npcLoc.distance(location) < 1.0) {
                NMS.setHeadAndBodyYaw(this.getEntity(), location.getYaw());
            }
            if (this.getEntity().getType() == EntityType.PLAYER && !this.getEntity().isInsideVehicle() && NMS.getPassengers(this.getEntity()).size() == 0) {
                NPCTeleportEvent event = new NPCTeleportEvent((NPC)this, location);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                NMS.setLocationDirectly(this.getEntity(), location);
                return;
            }
        }
        super.teleport(location, reason);
    }

    public String toString() {
        EntityType mobType = this.hasTrait(MobType.class) ? this.getTraitNullable(MobType.class).getType() : null;
        return this.getId() + "{" + this.getRawName() + ", " + mobType + "}";
    }

    @Override
    public void update() {
        try {
            Gravity trait;
            boolean shouldSwim;
            int range;
            super.update();
            if (!this.isSpawned()) {
                this.resetCachedCoord();
                return;
            }
            Location loc = this.getEntity().getLocation();
            if (this.data().has(NPC.Metadata.ACTIVATION_RANGE) && ((range = ((Integer)this.data().get(NPC.Metadata.ACTIVATION_RANGE)).intValue()) == -1 || CitizensAPI.getLocationLookup().getNearbyPlayers(loc, range).iterator().hasNext())) {
                NMS.activate(this.getEntity());
            }
            boolean bl = shouldSwim = this.data().get(NPC.Metadata.SWIM, Boolean.valueOf(!this.useMinecraftAI() && SwimmingExaminer.isWaterMob(this.getEntity()))) != false && MinecraftBlockExaminer.isLiquid(loc.getBlock().getType());
            if (this.navigator.isNavigating()) {
                if (shouldSwim) {
                    this.getEntity().setVelocity(this.getEntity().getVelocity().multiply(this.data().get(NPC.Metadata.WATER_SPEED_MODIFIER, Float.valueOf(Settings.Setting.NPC_WATER_SPEED_MODIFIER.asFloat())).floatValue()));
                    Location currentDest = this.navigator.getPathStrategy().getCurrentDestination();
                    if (currentDest == null || currentDest.getY() > loc.getY()) {
                        NMS.trySwim(this.getEntity());
                    }
                }
            } else if (shouldSwim && ((trait = this.getTraitNullable(Gravity.class)) == null || trait.hasGravity())) {
                NMS.trySwim(this.getEntity());
            }
            if (SUPPORT_GLOWING && this.data().has(NPC.Metadata.GLOWING)) {
                this.getEntity().setGlowing(this.data().get(NPC.Metadata.GLOWING, Boolean.valueOf(false)).booleanValue());
            }
            if (SUPPORT_SILENT && this.data().has(NPC.Metadata.SILENT)) {
                this.getEntity().setSilent(Boolean.parseBoolean(this.data().get(NPC.Metadata.SILENT).toString()));
            }
            if (this.data().has(NPC.Metadata.AGGRESSIVE)) {
                NMS.setAggressive(this.getEntity(), (Boolean)this.data().get(NPC.Metadata.AGGRESSIVE));
            }
            boolean isLiving = this.getEntity() instanceof LivingEntity;
            if (this.isUpdating(NPC.NPCUpdate.PACKET)) {
                ChunkCoord currentCoord;
                if (this.data().get(NPC.Metadata.KEEP_CHUNK_LOADED, Boolean.valueOf(Settings.Setting.KEEP_CHUNKS_LOADED.asBoolean())).booleanValue() && !(currentCoord = new ChunkCoord(loc)).equals(this.cachedCoord)) {
                    this.resetCachedCoord();
                    currentCoord.setForceLoaded(true);
                    CHUNK_LOADERS.put((Object)currentCoord, (Object)this);
                    this.cachedCoord = currentCoord;
                }
                if (isLiving) {
                    this.updateScoreboard();
                }
                this.updateCounter = 0;
            }
            this.updateCustomNameVisibility();
            if (isLiving) {
                NMS.setKnockbackResistance((LivingEntity)this.getEntity(), this.isProtected() ? 1.0 : 0.0);
                if (SUPPORT_PICKUP_ITEMS) {
                    ((LivingEntity)this.getEntity()).setCanPickupItems(this.data().get(NPC.Metadata.PICKUP_ITEMS, Boolean.valueOf(false)).booleanValue());
                }
                if (this.getEntity() instanceof Player) {
                    this.updateUsingItemState((Player)this.getEntity());
                }
            }
            this.navigator.run();
            ++this.updateCounter;
        }
        catch (Exception ex) {
            Throwable error = Throwables.getRootCause((Throwable)ex);
            Messaging.logTr("citizens.notifications.exception-updating-npc", this.getId(), error.getMessage());
            error.printStackTrace();
        }
    }

    private void updateCustomName() {
        if (this.getEntity() == null) {
            return;
        }
        if (this.coloredNameComponentCache != null) {
            NMS.setCustomName(this.getEntity(), this.coloredNameComponentCache, this.coloredNameStringCache);
        } else {
            this.getEntity().setCustomName(this.getFullName());
        }
    }

    private void updateCustomNameVisibility() {
        String nameplateVisible = ((Object)this.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        if (this.requiresNameHologram()) {
            nameplateVisible = "false";
        }
        if (nameplateVisible.equals("true") || nameplateVisible.equals("hover")) {
            this.updateCustomName();
        }
        this.getEntity().setCustomNameVisible(Boolean.parseBoolean(nameplateVisible));
    }

    private void updateFlyableState() {
        EntityType type;
        if (!CitizensAPI.hasImplementation()) {
            return;
        }
        EntityType entityType = type = this.isSpawned() ? this.getEntity().getType() : this.getOrAddTrait(MobType.class).getType();
        if (type == null || !Util.isAlwaysFlyable(type)) {
            return;
        }
        if (!this.data().has(NPC.Metadata.FLYABLE)) {
            this.data().setPersistent(NPC.Metadata.FLYABLE, (Object)true);
        }
        if (!this.hasTrait(Gravity.class)) {
            this.getOrAddTrait(Gravity.class).setHasGravity(false);
        }
    }

    private void updateScoreboard() {
        if (this.data().has(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME)) {
            this.getOrAddTrait(ScoreboardTrait.class).update();
        }
    }

    private void updateUsingItemState(Player player) {
        boolean useItem = this.data().get(NPC.Metadata.USING_HELD_ITEM, Boolean.valueOf(false));
        boolean offhand = this.data().get(NPC.Metadata.USING_OFFHAND_ITEM, Boolean.valueOf(false));
        if (!SUPPORT_USE_ITEM) {
            return;
        }
        if (this.data().has("citizens-was-using-item")) {
            PlayerAnimation.STOP_USE_ITEM.play(player, 64);
            this.data().remove("citizens-was-using-item");
        }
        try {
            if (useItem) {
                PlayerAnimation.START_USE_MAINHAND_ITEM.play(player, 64);
                this.data().set("citizens-was-using-item", (Object)true);
            } else if (offhand) {
                PlayerAnimation.START_USE_OFFHAND_ITEM.play(player, 64);
                this.data().set("citizens-was-using-item", (Object)true);
            }
        }
        catch (UnsupportedOperationException ex) {
            SUPPORT_USE_ITEM = false;
        }
    }

    static {
        try {
            Entity.class.getMethod("setGlowing", Boolean.TYPE);
            SUPPORT_GLOWING = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            Entity.class.getMethod("setSilent", Boolean.TYPE);
            SUPPORT_SILENT = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            LivingEntity.class.getMethod("setCanPickupItems", Boolean.TYPE);
            SUPPORT_PICKUP_ITEMS = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            Class.forName("org.bukkit.attribute.Attribute");
            SUPPORT_ATTRIBUTES = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

