/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.astar.Plan;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class Path
implements Plan {
    private List<Block> blockList;
    private int index = 0;
    private final PathEntry[] path;

    public Path(Collection<Vector> vector) {
        this.path = (PathEntry[])Iterables.toArray((Iterable)Iterables.transform(vector, input -> new PathEntry((Vector)input, Collections.emptyList())), PathEntry.class);
    }

    Path(Iterable<VectorNode> unfiltered, Vector goal) {
        List<Object> path = Lists.newArrayList();
        for (VectorNode node : unfiltered) {
            for (Vector vector : node.getPathVectors()) {
                path.add(new PathEntry(vector, node.callbacks));
            }
        }
        PathEntry goalEntry = new PathEntry(goal, ((PathEntry)path.get((int)(path.size() - 1))).callbacks);
        Vector last = ((PathEntry)path.get((int)(path.size() - 1))).vector;
        if (last.getBlockX() == goal.getBlockX() && last.getBlockY() == goal.getBlockY() && last.getBlockZ() == goal.getBlockZ()) {
            path.set(path.size() - 1, goalEntry);
        } else {
            path.add(goalEntry);
        }
        path = Path.ramerDouglasPeucker((List<PathEntry>)path, 0.75);
        this.path = path.toArray(new PathEntry[path.size()]);
    }

    public List<Block> getBlocks(World world) {
        return Arrays.asList(this.path).stream().map(p -> world.getBlockAt(p.vector.getBlockX(), p.vector.getBlockY(), p.vector.getBlockZ())).collect(Collectors.toList());
    }

    public Vector getCurrentVector() {
        return this.path[this.index].vector;
    }

    public Iterable<Vector> getPath() {
        return Iterables.transform(Arrays.asList(this.path), input -> input.vector);
    }

    @Override
    public boolean isComplete() {
        return this.index >= this.path.length;
    }

    public boolean isFinalEntry() {
        return this.index == this.path.length - 1;
    }

    public void run(NPC npc) {
        this.path[this.index].run(npc);
    }

    public String toString() {
        return Arrays.toString(this.path);
    }

    @Override
    public void update(Agent agent) {
        if (this.isComplete()) {
            return;
        }
        this.path[this.index].onComplete((NPC)agent);
        ++this.index;
    }

    private static List<PathEntry> ramerDouglasPeucker(List<PathEntry> points, double epsilon) {
        if (points.size() < 3) {
            return points;
        }
        int n = points.size();
        boolean[] keep = new boolean[n];
        keep[0] = true;
        keep[n - 1] = true;
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(new int[]{0, n - 1});
        while (!stack.isEmpty()) {
            int[] range = (int[])stack.pop();
            int start = range[0];
            int end = range[1];
            double dmax = 0.0;
            int found = -1;
            Vector a = points.get((int)start).vector;
            Vector b = points.get((int)end).vector;
            double abx = b.getX() - a.getX();
            double aby = b.getY() - a.getY();
            double abz = b.getZ() - a.getZ();
            double length = abx * abx + aby * aby + abz * abz;
            for (int i = start + 1; i < end; ++i) {
                double d;
                Vector p = points.get((int)i).vector;
                if (length < 1.0E-9) {
                    double dx = p.getX() - a.getX();
                    double dy = p.getY() - a.getY();
                    double dz = p.getZ() - a.getZ();
                    d = Math.sqrt(dx * dx + dy * dy + dz * dz);
                } else {
                    double cz;
                    double cy;
                    double apz;
                    double apx = p.getX() - a.getX();
                    double apy = p.getY() - a.getY();
                    double cx = apy * abz - (apz = p.getZ() - a.getZ()) * aby;
                    double crossProductLength = cx * cx + (cy = apz * abx - apx * abz) * cy + (cz = apx * aby - apy * abx) * cz;
                    if (crossProductLength <= epsilon * epsilon * length) continue;
                    d = Math.sqrt(crossProductLength / length);
                }
                if (!(d > dmax)) continue;
                dmax = d;
                found = i;
            }
            if (!(dmax > epsilon) || found == -1) continue;
            keep[found] = true;
            stack.push(new int[]{start, found});
            stack.push(new int[]{found, end});
        }
        ArrayList<PathEntry> result = new ArrayList<PathEntry>();
        for (int i = 0; i < n; ++i) {
            if (!keep[i]) continue;
            result.add(points.get(i));
        }
        return result;
    }

    private class PathEntry {
        final List<PathPoint.PathCallback> callbacks;
        final Vector vector;

        private PathEntry(Vector vector, List<PathPoint.PathCallback> callbacks) {
            this.vector = vector;
            this.callbacks = callbacks;
        }

        public void onComplete(NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            Block current = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback callback : this.callbacks) {
                callback.onReached(npc, current);
            }
        }

        public void run(NPC npc) {
            if (this.callbacks == null) {
                return;
            }
            Block current = npc.getEntity().getWorld().getBlockAt(this.vector.getBlockX(), this.vector.getBlockY(), this.vector.getBlockZ());
            for (PathPoint.PathCallback callback : this.callbacks) {
                if (Path.this.blockList == null) {
                    Path.this.blockList = Lists.transform(Arrays.asList(Path.this.path), input -> npc.getEntity().getWorld().getBlockAt(input.vector.getBlockX(), input.vector.getBlockY(), input.vector.getBlockZ()));
                }
                callback.run(npc, current, Path.this.blockList, Path.this.index);
            }
        }

        public String toString() {
            return this.vector.toString();
        }
    }
}

