/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.flocking.Flocker;
import net.citizensnpcs.api.ai.flocking.RadiusNPCFlock;
import net.citizensnpcs.api.ai.flocking.SeparationBehavior;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

@TraitName(value="followtrait")
public class FollowTrait
extends Trait {
    private Entity entity;
    private Flocker flock;
    @Persist
    private UUID followingUUID;
    @Persist
    private double margin = -1.0;
    @Persist
    private boolean protect;

    public FollowTrait() {
        super("followtrait");
    }

    private void cancelNavigationIfActive() {
        if (this.npc.getNavigator().isNavigating() && this.entity != null && this.npc.getNavigator().getEntityTarget() != null && this.entity == this.npc.getNavigator().getEntityTarget().getTarget()) {
            this.npc.getNavigator().cancelNavigation();
        }
    }

    public void follow(Entity follow) {
        this.cancelNavigationIfActive();
        this.followingUUID = follow == null ? null : follow.getUniqueId();
        this.entity = null;
    }

    public Entity getFollowing() {
        return this.entity;
    }

    public double getFollowingMargin() {
        return this.margin;
    }

    public boolean isActive() {
        return this.npc.isSpawned() && this.entity != null;
    }

    public boolean isEnabled() {
        return this.followingUUID != null;
    }

    @Override
    public void onDespawn() {
        this.flock = null;
    }

    @EventHandler
    private void onEntityDamage(EntityDamageByEntityEvent event) {
        if (this.isActive() && this.protect && event.getEntity().equals((Object)this.entity)) {
            Projectile projectile;
            Entity damager = event.getDamager();
            if (event.getEntity() instanceof Projectile && (projectile = (Projectile)event.getEntity()).getShooter() instanceof Entity) {
                damager = (Entity)projectile.getShooter();
            }
            this.npc.getNavigator().setTarget(damager, true);
        }
    }

    @Override
    public void onSpawn() {
        this.flock = new Flocker(this.npc, new RadiusNPCFlock(4.0, 4), new SeparationBehavior(1.0));
    }

    @Override
    public void run() {
        if (this.entity == null || !this.entity.isValid()) {
            if (this.followingUUID == null) {
                return;
            }
            this.entity = Bukkit.getPlayer((UUID)this.followingUUID);
            if (this.entity == null) {
                this.entity = Util.getEntity(this.followingUUID);
            }
            if (this.entity == null) {
                return;
            }
        }
        if (!this.isActive()) {
            return;
        }
        if (!this.npc.getEntity().getWorld().equals((Object)this.entity.getWorld())) {
            if (Settings.Setting.FOLLOW_ACROSS_WORLDS.asBoolean()) {
                this.npc.teleport(this.entity.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            return;
        }
        if (!this.npc.getNavigator().isNavigating()) {
            this.npc.getNavigator().setTarget(this.entity, false);
            if (this.margin > 0.0) {
                this.npc.getNavigator().getLocalParameters().distanceMargin(this.margin);
            }
        } else {
            this.flock.run();
        }
    }

    public void setFollowingMargin(double margin) {
        this.margin = margin;
        this.cancelNavigationIfActive();
    }

    public void setProtect(boolean protect) {
        this.protect = protect;
        this.cancelNavigationIfActive();
    }
}

