/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCAddTraitEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.PlayerFilter;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.event.EventHandler;

@TraitName(value="clickredirecttrait")
public class ClickRedirectTrait
extends Trait {
    private NPC redirectTo;

    public ClickRedirectTrait() {
        super("clickredirecttrait");
    }

    public ClickRedirectTrait(NPC redirectTo) {
        this();
        this.redirectTo = redirectTo;
    }

    public NPC getRedirectToNPC() {
        return this.redirectTo;
    }

    @Override
    public void linkToNPC(NPC npc) {
        super.linkToNPC(npc);
        if (this.redirectTo != null && this.redirectTo.hasTrait(PlayerFilter.class)) {
            this.redirectTo.getOrAddTrait(PlayerFilter.class).addChildNPC(npc);
        }
    }

    @Override
    public void load(DataKey key) {
        this.redirectTo = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(UUID.fromString(key.getString("uuid")));
    }

    @EventHandler
    public void onTraitAdd(NPCAddTraitEvent event) {
        if (event.getNPC() == this.redirectTo && event.getTrait() instanceof PlayerFilter) {
            ((PlayerFilter)event.getTrait()).addChildNPC(this.npc);
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("uuid");
        if (this.redirectTo == null) {
            return;
        }
        key.setString("uuid", this.redirectTo.getUniqueId().toString());
    }
}

