/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Pose;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class Poses
extends Trait {
    private final List<Pose> poses = new ArrayList<Pose>();

    public Poses() {
        super("poses");
    }

    public boolean addPose(String name, Location location) {
        Pose newPose = new Pose(name, location.getPitch(), location.getYaw());
        if (this.poses.contains(newPose)) {
            return false;
        }
        this.poses.add(newPose);
        return true;
    }

    public void assumePose(Pose pose) {
        if (!this.npc.isSpawned()) {
            this.npc.spawn(this.npc.getTrait(CurrentLocation.class).getLocation());
        }
        Util.assumePose((Entity)this.npc.getBukkitEntity(), pose);
    }

    public Pose getPose(String name) {
        for (Pose pose : this.poses) {
            if (!pose.getName().equalsIgnoreCase(name)) continue;
            return pose;
        }
        return null;
    }

    public List<Pose> getPoses() {
        return this.poses;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey sub : key.getRelative("list").getIntegerSubKeys()) {
            try {
                String[] parts = sub.getString("").split(";");
                this.poses.add(new Pose(parts[0], Float.valueOf(parts[1]).floatValue(), Float.valueOf(parts[2]).floatValue()));
            }
            catch (NumberFormatException e) {
                Messaging.logF("Skipping pose %s - invalid yaw/pitch (%s).", sub.name(), e.getMessage());
            }
        }
    }

    public boolean removePose(Pose pose) {
        if (this.poses.contains(pose)) {
            this.poses.remove(pose);
            return true;
        }
        return false;
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("list");
        for (int i = 0; i < this.poses.size(); ++i) {
            key.setString("list." + String.valueOf(i), this.poses.get(i).stringValue());
        }
    }
}

