/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.speech;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.ai.speech.Talkable;
import net.citizensnpcs.api.ai.speech.event.SpeechBystanderEvent;
import net.citizensnpcs.api.ai.speech.event.SpeechTargetedEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TalkableEntity
implements Talkable {
    private final Entity entity;

    public TalkableEntity(Entity entity) {
        this.entity = entity;
    }

    public TalkableEntity(NPC npc) {
        this.entity = npc.getEntity();
    }

    @Override
    public int compareTo(Object o) {
        if (!(o instanceof Entity)) {
            return -1;
        }
        if (CitizensAPI.getNPCRegistry().isNPC((Entity)o) && CitizensAPI.getNPCRegistry().isNPC(this.entity) && CitizensAPI.getNPCRegistry().getNPC((Entity)o).getUniqueId().equals(CitizensAPI.getNPCRegistry().getNPC(this.entity).getUniqueId()) || this.entity.equals(o)) {
            return 0;
        }
        return 1;
    }

    @Override
    public Entity getEntity() {
        return this.entity;
    }

    @Override
    public String getName() {
        if (CitizensAPI.getNPCRegistry().isNPC(this.entity)) {
            return CitizensAPI.getNPCRegistry().getNPC(this.entity).getFullName();
        }
        if (this.entity instanceof Player) {
            return ((Player)this.entity).getName();
        }
        return this.entity.getType().name().replace("_", " ");
    }

    private void talk(NPC npc, String message) {
        if (!CitizensAPI.getNPCRegistry().isNPC(this.entity)) {
            Messaging.sendWithNPCColorless((CommandSender)this.entity, message, npc);
        }
    }

    @Override
    public void talkNear(SpeechContext context, String text) {
        SpeechBystanderEvent event = new SpeechBystanderEvent(this, context, text);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getContext().getTalker().getEntity());
        this.talk(npc, event.getMessage());
    }

    @Override
    public void talkTo(SpeechContext context, String text) {
        SpeechTargetedEvent event = new SpeechTargetedEvent(this, context, text);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        NPC npc = CitizensAPI.getNPCRegistry().getNPC(event.getContext().getTalker().getEntity());
        this.talk(npc, event.getMessage());
    }
}

