/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.logging.Level;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Translator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Messaging {
    private static final Joiner SPACE = Joiner.on((String)" ").useForNull("null");

    public static void debug(Object ... msg) {
        if (Settings.Setting.DEBUG_MODE.asBoolean()) {
            Messaging.log(msg);
        }
    }

    private static String getFormatted(Object[] msg) {
        String toFormat = msg[0].toString();
        Object[] args = msg.length > 1 ? Arrays.copyOfRange(msg, 1, msg.length) : new Object[]{};
        return String.format(toFormat, args);
    }

    public static void log(Level level, Object ... msg) {
        Bukkit.getLogger().log(level, "[Citizens] " + SPACE.join(msg));
    }

    public static void log(Object ... msg) {
        Messaging.log(Level.INFO, msg);
    }

    public static void log(Throwable ex) {
        if (ex.getCause() != null) {
            ex = ex.getCause();
        }
        ex.printStackTrace();
    }

    public static void logF(Object ... msg) {
        Messaging.log(Messaging.getFormatted(msg));
    }

    public static void logTr(String key, Object ... msg) {
        Messaging.log(Level.INFO, Translator.tr(key, msg));
    }

    public static void send(CommandSender sender, Object ... msg) {
        Messaging.sendMessageTo(sender, SPACE.join(msg));
    }

    public static void sendError(CommandSender sender, Object ... msg) {
        Messaging.send(sender, ChatColor.RED.toString() + SPACE.join(msg));
    }

    public static void sendErrorF(CommandSender sender, Object ... msg) {
        Messaging.sendF(sender, ChatColor.RED.toString() + SPACE.join(msg));
    }

    public static void sendErrorTr(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, ChatColor.RED + Translator.tr(key, msg));
    }

    public static void sendF(CommandSender sender, Object ... msg) {
        Messaging.sendMessageTo(sender, Messaging.getFormatted(msg));
    }

    private static void sendMessageTo(CommandSender sender, String msg) {
        msg = StringHelper.parseColors(msg);
        sender.sendMessage(msg);
    }

    public static void sendTr(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, Translator.tr(key, msg));
    }

    public static void sendWithNPC(CommandSender sender, Object msg, NPC npc) {
        String send = msg.toString();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            send = send.replace("<player>", player.getName());
            send = send.replace("<world>", player.getWorld().getName());
        }
        send = send.replace("<owner>", npc.getTrait(Owner.class).getOwner());
        send = send.replace("<npc>", npc.getName());
        send = send.replace("<id>", Integer.toString(npc.getId()));
        Messaging.send(sender, send);
    }

    public static void severe(Object ... messages) {
        Messaging.log(Level.SEVERE, messages);
    }

    public static void severeF(Object ... messages) {
        Messaging.log(Level.SEVERE, Messaging.getFormatted(messages));
    }

    public static void severeTr(String key, Object ... messages) {
        Messaging.log(Level.SEVERE, Translator.tr(key, messages));
    }

    public static String tr(String key, Object ... messages) {
        return Translator.tr(key, messages);
    }
}

