/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import org.bukkit.entity.EntityType;

public class SimpleNPCDataStore
implements NPCDataStore {
    private final Storage root;
    private static final String LOAD_NAME_NOT_FOUND = "citizens.notifications.npc-name-not-found";
    private static final String LOAD_UNKNOWN_NPC_TYPE = "citizens.notifications.unknown-npc-type";

    public SimpleNPCDataStore(Storage saves) {
        this.root = saves;
    }

    @Override
    public void clearData(NPC npc) {
        this.root.getKey("npc").removeKey(Integer.toString(npc.getId()));
    }

    @Override
    public void clearTraitData(Iterable<String> traitNames) {
        for (DataKey key : this.root.getKey("npc").getSubKeys()) {
            Set storedNames = Splitter.on((char)',').splitToStream((CharSequence)key.getString("traitnames")).collect(Collectors.toSet());
            DataKey traits = key.getRelative("traits");
            for (String trait : traitNames) {
                trait = trait.toLowerCase(Locale.ROOT);
                traits.removeKey(trait);
                storedNames.remove(trait);
            }
            key.setString("traitnames", Joiner.on((char)',').join(storedNames));
        }
    }

    @Override
    public int createUniqueNPCId(NPCRegistry registry) {
        DataKey key = this.root.getKey("");
        int newId = key.getInt("last-created-npc-id", -1);
        if (newId == -1 || registry.getById(newId + 1) != null) {
            int maxId = Integer.MIN_VALUE;
            for (NPC npc : registry) {
                if (npc.getId() <= maxId) continue;
                maxId = npc.getId();
            }
            newId = maxId == Integer.MIN_VALUE ? 0 : maxId + 1;
        } else {
            ++newId;
        }
        key.setInt("last-created-npc-id", newId);
        return newId;
    }

    @Override
    public void loadInto(NPCRegistry registry) {
        for (DataKey key : this.root.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                Messaging.logTr(LOAD_NAME_NOT_FOUND, id);
                continue;
            }
            String unparsedEntityType = key.getRelative("traits").getString("type", "PLAYER");
            EntityType type = SimpleNPCDataStore.matchEntityType(unparsedEntityType);
            if (type == null) {
                Messaging.logTr(LOAD_UNKNOWN_NPC_TYPE, unparsedEntityType);
                continue;
            }
            NPC npc = registry.createNPC(type, !key.getString("uuid").isEmpty() ? UUID.fromString(key.getString("uuid")) : UUID.randomUUID(), id, key.getString("name"));
            npc.load(key);
        }
    }

    @Override
    public void reloadFromSource() {
        this.root.load();
    }

    @Override
    public void saveToDisk() {
        this.root.saveAsync();
    }

    @Override
    public void saveToDiskImmediate() {
        this.root.save();
    }

    @Override
    public void store(NPC npc) {
        npc.save(this.root.getKey("npc." + npc.getId()));
    }

    @Override
    public void storeAll(NPCRegistry registry) {
        for (NPC npc : registry) {
            this.store(npc);
        }
    }

    public static NPCDataStore create(Storage storage) {
        return new SimpleNPCDataStore(storage);
    }

    private static EntityType matchEntityType(String toMatch) {
        EntityType type;
        try {
            type = EntityType.valueOf((String)toMatch);
        }
        catch (IllegalArgumentException ex) {
            type = EntityType.fromName((String)toMatch);
        }
        if (type != null) {
            return type;
        }
        return (EntityType)SimpleNPCDataStore.matchEnum((Enum[])EntityType.values(), (String)toMatch);
    }

    private static <T extends Enum<?>> T matchEnum(T[] values, String toMatch) {
        T type = null;
        for (T check : values) {
            String name = ((Enum)check).name();
            if (!name.matches(toMatch) && !name.equalsIgnoreCase(toMatch) && !name.replace("_", "").equalsIgnoreCase(toMatch) && !name.replace('_', '-').equalsIgnoreCase(toMatch) && !name.replace('_', ' ').equalsIgnoreCase(toMatch) && !name.startsWith(toMatch)) continue;
            type = check;
            break;
        }
        return type;
    }
}

