/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R6.util;

import com.google.common.collect.ForwardingSet;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.citizensnpcs.api.event.NPCLinkToPlayerEvent;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.NPCUnlinkFromPlayerEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R6.entity.EntityHumanNPC;
import net.citizensnpcs.nms.v1_21_R6.util.NMSImpl;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.EntityTrackerEntry;
import net.minecraft.server.level.PlayerChunkMap;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class CitizensEntityTracker
extends PlayerChunkMap.EntityTracker {
    private final cdv tracker;
    private static volatile Boolean REQUIRES_SYNC;
    private static final MethodHandle TRACK_DELTA;
    private static final MethodHandle TRACKER;
    private static final MethodHandle TRACKER_ENTRY;
    private static final MethodHandle TRACKING_RANGE;
    private static final MethodHandle TRACKING_RANGE_SETTER;
    private static final MethodHandle TRACKING_SET_SETTER;
    private static final MethodHandle UPDATE_INTERVAL;

    public CitizensEntityTracker(PlayerChunkMap map, cdv entity, int i, int j, boolean flag) {
        PlayerChunkMap playerChunkMap = map;
        Objects.requireNonNull(playerChunkMap);
        super(playerChunkMap, entity, i, j, flag);
        this.tracker = entity;
        try {
            final Set set = this.f;
            TRACKING_SET_SETTER.invoke(this, new ForwardingSet<ayc>(){

                public boolean add(ayc conn) {
                    boolean res = super.add((Object)conn);
                    if (res) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCLinkToPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)conn.o().getBukkitEntity(), !Bukkit.isPrimaryThread()));
                    }
                    return res;
                }

                protected Set<ayc> delegate() {
                    return set;
                }

                public boolean remove(Object conn) {
                    boolean removed = super.remove(conn);
                    if (removed) {
                        Bukkit.getPluginManager().callEvent((Event)new NPCUnlinkFromPlayerEvent(((NPCHolder)CitizensEntityTracker.this.tracker).getNPC(), (Player)((ayc)conn).o().getBukkitEntity()));
                    }
                    return removed;
                }
            });
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    public CitizensEntityTracker(PlayerChunkMap map, PlayerChunkMap.EntityTracker entry) {
        this(map, CitizensEntityTracker.getTracker(entry), CitizensEntityTracker.getTrackingDistance(entry), CitizensEntityTracker.getUpdateInterval(entry), CitizensEntityTracker.getTrackDelta(entry));
    }

    public void b(EntityPlayer entityplayer) {
        if (entityplayer instanceof EntityHumanNPC) {
            return;
        }
        if (!this.tracker.ec() && !this.f.contains(entityplayer.g) && this.tracker instanceof NPCHolder) {
            boolean cancelled;
            NPC npc = ((NPCHolder)this.tracker).getNPC();
            if (REQUIRES_SYNC == null) {
                REQUIRES_SYNC = !Bukkit.isPrimaryThread();
            }
            if (cancelled = ((Boolean)Util.callPossiblySync(() -> {
                NPCSeenByPlayerEvent event = new NPCSeenByPlayerEvent(npc, (Player)entityplayer.getBukkitEntity());
                try {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                catch (IllegalStateException e2) {
                    REQUIRES_SYNC = true;
                    throw e2;
                }
                if (event.isCancelled()) {
                    return true;
                }
                Integer trackingRange = (Integer)npc.data().get(NPC.Metadata.TRACKING_RANGE);
                if (TRACKING_RANGE_SETTER != null && trackingRange != null && ((Integer)npc.data().get("last-tracking-range", (Object)-1)).intValue() != trackingRange.intValue()) {
                    try {
                        TRACKING_RANGE_SETTER.invoke(this, trackingRange);
                        npc.data().set("last-tracking-range", (Object)trackingRange);
                    }
                    catch (Throwable e3) {
                        e3.printStackTrace();
                    }
                }
                return false;
            }, (boolean)REQUIRES_SYNC)).booleanValue()) {
                return;
            }
        }
        super.b(entityplayer);
    }

    public static Collection<Entity> getSeenBy(PlayerChunkMap.EntityTracker tracker) {
        return tracker.f.stream().map(c2 -> c2.o().getBukkitEntity()).collect(Collectors.toSet());
    }

    private static boolean getTrackDelta(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACK_DELTA.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    private static cdv getTracker(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKER.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    private static int getTrackingDistance(PlayerChunkMap.EntityTracker entry) {
        try {
            return TRACKING_RANGE.invoke(entry);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    private static int getUpdateInterval(PlayerChunkMap.EntityTracker entry) {
        try {
            return UPDATE_INTERVAL.invoke(TRACKER_ENTRY.invoke(entry));
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    static {
        TRACK_DELTA = NMSImpl.SERVER_ENTITY_TRACK_DELTA;
        TRACKER = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, cdv.class);
        TRACKER_ENTRY = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, EntityTrackerEntry.class);
        TRACKING_RANGE = NMS.getFirstGetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        TRACKING_RANGE_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Integer.TYPE);
        TRACKING_SET_SETTER = NMS.getFirstFinalSetter(PlayerChunkMap.EntityTracker.class, Set.class);
        UPDATE_INTERVAL = NMSImpl.SERVER_ENTITY_UPDATE_INTERVAL;
    }
}

