/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.function.Function;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Villager;

public class OldEnumCompat {
    private static final MethodHandle OBJECT_EQUALS = OldEnumCompat.getMethod(Object.class, "equals", Object.class);
    private static final MethodHandle OBJECT_HASHCODE = OldEnumCompat.getMethod(Object.class, "hashCode", new Class[0]);
    private static final MethodHandle OBJECT_TOSTRING = OldEnumCompat.getMethod(Object.class, "toString", new Class[0]);

    private static MethodHandle getMethod(Class<?> clazz, String method, Class<?> ... params) {
        try {
            Method f = null;
            try {
                f = clazz.getMethod(method, params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return MethodHandles.publicLookup().unreflect(f);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class VillagerTypeEnum
    extends ReflectiveOldEnum<Villager.Type> {
        private static final Methods METHODS = new Methods(Villager.Type.class);

        public VillagerTypeEnum(Villager.Type instance) {
            super(instance, METHODS);
        }

        public static VillagerTypeEnum valueOf(String name) {
            return VillagerTypeEnum.reflectValueOf(name, METHODS, t -> new VillagerTypeEnum((Villager.Type)t));
        }

        public static VillagerTypeEnum[] values() {
            return VillagerTypeEnum.reflectValues(METHODS, t -> new VillagerTypeEnum((Villager.Type)t));
        }
    }

    public static class VillagerProfessionEnum
    extends ReflectiveOldEnum<Villager.Profession> {
        private static final Methods METHODS = new Methods(Villager.Profession.class);

        public VillagerProfessionEnum(Villager.Profession instance) {
            super(instance, METHODS);
        }

        public static VillagerProfessionEnum valueOf(String name) {
            return VillagerProfessionEnum.reflectValueOf(name, METHODS, t -> new VillagerProfessionEnum((Villager.Profession)t));
        }

        public static VillagerProfessionEnum[] values() {
            return VillagerProfessionEnum.reflectValues(METHODS, t -> new VillagerProfessionEnum((Villager.Profession)t));
        }
    }

    private static abstract class ReflectiveOldEnum<T> {
        private final T instance;
        private final Methods methods;

        private ReflectiveOldEnum(T t, Methods staticMethods) {
            this.instance = t;
            this.methods = staticMethods;
        }

        public boolean equals(Object other) {
            try {
                return OBJECT_EQUALS.invoke(other);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }

        public T getInstance() {
            return this.instance;
        }

        public int hashCode() {
            try {
                return OBJECT_HASHCODE.invoke(this.instance);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return 0;
            }
        }

        public String name() {
            try {
                return this.methods.name.invoke(this.instance);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            try {
                return OBJECT_TOSTRING.invoke(this.instance);
            }
            catch (Throwable e) {
                e.printStackTrace();
                return "";
            }
        }

        protected static <T> T reflectValueOf(String name, Methods METHODS, Function<Object, T> constructor) {
            try {
                return constructor.apply(METHODS.valueOf.invoke(name));
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }

        protected static <T> T[] reflectValues(Methods METHODS, Function<Object, T> constructor) {
            try {
                Object[] values = METHODS.values.invoke();
                Object[] result = (Object[])Array.newInstance(constructor.apply(values[0]).getClass(), values.length);
                for (int i = 0; i < values.length; ++i) {
                    result[i] = constructor.apply(values[i]);
                }
                return result;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class Methods {
        private final Class<?> clazz;
        private final MethodHandle name;
        private final MethodHandle valueOf;
        private final MethodHandle values;

        public Methods(Class<?> clazz) {
            this.clazz = clazz;
            this.valueOf = OldEnumCompat.getMethod(clazz, "valueOf", new Class[]{String.class});
            this.name = OldEnumCompat.getMethod(clazz, "name", new Class[0]);
            this.values = OldEnumCompat.getMethod(clazz, "values", new Class[0]);
        }
    }

    public static class FrogVariantEnum
    extends ReflectiveOldEnum<Frog.Variant> {
        private static final Methods METHODS = new Methods(Frog.Variant.class);

        public FrogVariantEnum(Frog.Variant instance) {
            super(instance, METHODS);
        }

        public static FrogVariantEnum valueOf(String name) {
            return FrogVariantEnum.reflectValueOf(name, METHODS, t -> new FrogVariantEnum((Frog.Variant)t));
        }

        public static FrogVariantEnum[] values() {
            return FrogVariantEnum.reflectValues(METHODS, t -> new FrogVariantEnum((Frog.Variant)t));
        }
    }

    public static class CatTypeEnum
    extends ReflectiveOldEnum<Cat.Type> {
        private static final Methods METHODS = new Methods(Cat.Type.class);

        public CatTypeEnum(Cat.Type instance) {
            super(instance, METHODS);
        }

        public static CatTypeEnum valueOf(String name) {
            return CatTypeEnum.reflectValueOf(name, METHODS, t -> new CatTypeEnum((Cat.Type)t));
        }

        public static CatTypeEnum[] values() {
            return CatTypeEnum.reflectValues(METHODS, t -> new CatTypeEnum((Cat.Type)t));
        }
    }
}

