/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.NPCSeenByPlayerEvent;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitEventHandler;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.Equipment;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

@TraitName(value="mirrortrait")
public class MirrorTrait
extends Trait {
    @Persist
    private volatile boolean enabled;
    private volatile BiFunction<Player, Equipment.EquipmentSlot, ItemStack> equipmentFunction;
    @Persist
    private volatile boolean mirrorEquipment;
    @Persist
    private volatile boolean mirrorName;
    private static final Map<EquipmentSlot, ItemStack> EMPTY_EQUIPMENT_MAP = ImmutableMap.of((Object)EquipmentSlot.HAND, (Object)new ItemStack(Material.AIR, 1));
    private static final BiFunction<Player, Equipment.EquipmentSlot, ItemStack> MIRROR_EQUIPMENT = (player, slot) -> player.getInventory().getItem(slot.toBukkit());

    public MirrorTrait() {
        super("mirrortrait");
    }

    public BiFunction<Player, Equipment.EquipmentSlot, ItemStack> getEquipmentFunction() {
        return this.mirrorEquipment && this.equipmentFunction == null ? MIRROR_EQUIPMENT : this.equipmentFunction;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isMirroring(Player player) {
        return this.enabled;
    }

    public boolean isMirroringEquipment() {
        return this.mirrorEquipment;
    }

    public boolean mirrorName() {
        return this.mirrorName;
    }

    @TraitEventHandler(value=@EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR))
    private void onSeenByPlayer(NPCSeenByPlayerEvent event) {
        if (!this.isMirroringEquipment() || !this.npc.hasTrait(Equipment.class)) {
            return;
        }
        for (ItemStack stack : this.npc.getOrAddTrait(Equipment.class).getEquipment()) {
            if (stack == null || stack.getType() == Material.AIR) continue;
            return;
        }
        event.getPlayer().sendEquipmentChange((LivingEntity)this.npc.getEntity(), EMPTY_EQUIPMENT_MAP);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.npc.isSpawned()) {
            this.npc.despawn(DespawnReason.PENDING_RESPAWN);
            this.npc.spawn(this.npc.getStoredLocation(), SpawnReason.RESPAWN);
        }
    }

    public void setEquipmentFunction(BiFunction<Player, Equipment.EquipmentSlot, ItemStack> func) {
        this.equipmentFunction = func;
    }

    public void setMirrorEquipment(boolean mirrorEquipment) {
        this.mirrorEquipment = mirrorEquipment;
    }

    public void setMirrorName(boolean mirror) {
        this.mirrorName = mirror;
    }
}

