/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Set;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

@TraitName(value="scoreboardtrait")
public class ScoreboardTrait
extends Trait {
    private boolean changed;
    @Persist
    private ChatColor color;
    private String lastName;
    private final LocationLookup.PerPlayerMetadata<Boolean> metadata;
    private ChatColor previousGlowingColor;
    @Persist
    private Set<String> tags = Sets.newHashSet((Object[])new String[]{"CITIZENS_NPC"});
    private static boolean SUPPORT_COLLIDABLE_SETOPTION = true;
    private static boolean SUPPORT_GLOWING_COLOR = false;
    private static boolean SUPPORT_TAGS = false;
    private static boolean SUPPORT_TEAM_SETOPTION = true;

    public ScoreboardTrait() {
        super("scoreboardtrait");
        this.metadata = CitizensAPI.getLocationLookup().registerMetadata("scoreboard", (meta, event) -> {
            for (NPC npc : Iterables.concat(CitizensAPI.getNPCRegistries())) {
                Team team;
                ScoreboardTrait trait = npc.getTraitNullable(ScoreboardTrait.class);
                if (trait == null || (team = trait.getTeam()) == null || meta.has(event.getPlayer().getUniqueId(), team.getName())) continue;
                NMS.sendTeamPacket(event.getPlayer(), team, 0);
                meta.set(event.getPlayer().getUniqueId(), team.getName(), true);
            }
        });
    }

    private void clearClientTeams(Team team) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!this.metadata.remove(player.getUniqueId(), team.getName())) continue;
            NMS.sendTeamPacket(player, team, 1);
        }
    }

    public void createTeam(String entityName) {
        if (SpigotUtil.isFoliaServer()) {
            return;
        }
        String teamName = Util.getTeamName(this.npc.getUniqueId());
        this.npc.data().set(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, (Object)teamName);
        Scoreboard scoreboard = Util.getDummyScoreboard();
        Team team = scoreboard.getTeam(teamName);
        if (team == null) {
            team = scoreboard.registerNewTeam(teamName);
        }
        if (!team.hasEntry(entityName)) {
            this.clearClientTeams(team);
        }
        team.addEntry(entityName);
    }

    public ChatColor getColor() {
        return this.color;
    }

    private Team getTeam() {
        String teamName = this.npc.data().get(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, "");
        if (teamName.isEmpty()) {
            return null;
        }
        return Util.getDummyScoreboard().getTeam(teamName);
    }

    @Override
    public void load(DataKey key) {
        if (this.color != null && this.color.isFormat()) {
            this.color = null;
        }
    }

    @Override
    public void onDespawn(DespawnReason reason) {
        if (SpigotUtil.isFoliaServer()) {
            return;
        }
        this.previousGlowingColor = null;
        String name = this.lastName;
        String teamName = this.npc.data().get(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME, "");
        if (teamName.isEmpty()) {
            return;
        }
        Team team = Util.getDummyScoreboard().getTeam(teamName);
        this.npc.data().remove(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME);
        if (team == null || name == null || !team.hasEntry(name)) {
            try {
                if (team != null && team.getSize() == 0) {
                    this.clearClientTeams(team);
                    team.unregister();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            return;
        }
        Runnable cleanup = () -> {
            if (this.npc.isSpawned()) {
                return;
            }
            try {
                team.getSize();
            }
            catch (IllegalStateException ex) {
                return;
            }
            if (team.getSize() <= 1) {
                this.clearClientTeams(team);
                team.unregister();
            } else {
                team.removeEntry(name);
            }
        };
        if (reason == DespawnReason.REMOVAL || reason == DespawnReason.RELOAD) {
            cleanup.run();
        } else {
            CitizensAPI.getScheduler().runEntityTaskLater(this.npc.getEntity(), cleanup, reason == DespawnReason.DEATH && this.npc.getEntity() instanceof LivingEntity ? 20L : 2L);
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn(DespawnReason.REMOVAL);
    }

    @Override
    public void onSpawn() {
        this.changed = true;
        if (SUPPORT_TAGS) {
            this.npc.getEntity().getScoreboardTags().clear();
            this.npc.getEntity().getScoreboardTags().addAll(this.tags);
        }
    }

    public void setColor(ChatColor color) {
        if (color.isFormat()) {
            throw new IllegalArgumentException();
        }
        this.color = color;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public void update() {
        if (SUPPORT_TAGS && !this.npc.getEntity().getScoreboardTags().equals(this.tags)) {
            this.tags = Sets.newHashSet((Iterable)this.npc.getEntity().getScoreboardTags());
        }
        String forceVisible = ((Object)this.npc.data().get(NPC.Metadata.NAMEPLATE_VISIBLE, Boolean.valueOf(true))).toString();
        boolean nameVisibility = !this.npc.requiresNameHologram() && (forceVisible.equals("true") || forceVisible.equals("hover"));
        Team team = this.getTeam();
        if (team == null) {
            return;
        }
        if (!Settings.Setting.USE_SCOREBOARD_TEAMS.asBoolean()) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                this.metadata.remove(player.getUniqueId(), team.getName());
                NMS.sendTeamPacket(player, team, 1);
            }
            team.unregister();
            this.npc.data().remove(NPC.Metadata.SCOREBOARD_FAKE_TEAM_NAME);
            return;
        }
        if (this.npc.isSpawned()) {
            String string = this.lastName = this.npc.getEntity() instanceof Player && this.npc.getEntity().getName() != null ? this.npc.getEntity().getName() : this.npc.getUniqueId().toString();
        }
        if (SUPPORT_TEAM_SETOPTION) {
            Team.OptionStatus visibility;
            Team.OptionStatus optionStatus = visibility = nameVisibility ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
            if (visibility != team.getOption(Team.Option.NAME_TAG_VISIBILITY)) {
                this.changed = true;
            }
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, visibility);
        } else {
            NMS.setTeamNameTagVisible(team, nameVisibility);
        }
        if (SUPPORT_COLLIDABLE_SETOPTION) {
            try {
                Team.OptionStatus collide;
                Team.OptionStatus optionStatus = collide = this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())) != false ? Team.OptionStatus.ALWAYS : Team.OptionStatus.NEVER;
                if (collide != team.getOption(Team.Option.COLLISION_RULE)) {
                    this.changed = true;
                }
                team.setOption(Team.Option.COLLISION_RULE, collide);
            }
            catch (NoSuchMethodError e) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
            catch (NoClassDefFoundError e) {
                SUPPORT_COLLIDABLE_SETOPTION = false;
            }
        }
        if (this.color != null) {
            if (SUPPORT_GLOWING_COLOR) {
                if (team.getColor() == null || this.previousGlowingColor == null || this.previousGlowingColor != null && this.color != this.previousGlowingColor) {
                    team.setColor(this.color);
                    this.previousGlowingColor = this.color;
                    this.changed = true;
                }
            } else if (team.getPrefix() == null || team.getPrefix().length() == 0 || this.previousGlowingColor == null || this.previousGlowingColor != null && !team.getPrefix().equals(this.previousGlowingColor.toString())) {
                team.setPrefix(this.color.toString());
                this.previousGlowingColor = this.color;
                this.changed = true;
            }
        }
        if (!this.changed) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player.hasMetadata("NPC")) continue;
            if (this.metadata.has(player.getUniqueId(), team.getName())) {
                NMS.sendTeamPacket(player, team, 2);
                continue;
            }
            NMS.sendTeamPacket(player, team, 0);
            this.metadata.set(player.getUniqueId(), team.getName(), true);
        }
        this.changed = false;
    }

    static {
        try {
            Entity.class.getDeclaredMethod("getScoreboardTags", new Class[0]);
            SUPPORT_TAGS = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        try {
            Team.class.getDeclaredMethod("getColor", new Class[0]);
            SUPPORT_GLOWING_COLOR = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }
}

