/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Snowman;

@TraitName(value="snowmantrait")
public class SnowmanTrait
extends Trait {
    @Persist(value="derp")
    private boolean derp;
    @Persist
    private boolean formSnow;

    public SnowmanTrait() {
        super("snowmantrait");
    }

    public boolean isDerp() {
        return this.derp;
    }

    @Override
    public void run() {
        if (this.npc.getEntity() instanceof Snowman) {
            ((Snowman)this.npc.getEntity()).setDerp(this.derp);
        }
    }

    public void setDerp(boolean derp) {
        this.derp = derp;
    }

    public void setFormSnow(boolean snow) {
        this.formSnow = snow;
    }

    public boolean shouldFormSnow() {
        return this.formSnow;
    }

    public boolean toggleDerp() {
        this.derp = !this.derp;
        return this.derp;
    }

    @Command(aliases={"npc"}, usage="snowman (-d[erp]) (-f[orm snow])", desc="", modifiers={"snowman", "snowgolem"}, min=1, max=1, flags="df", permission="citizens.npc.snowman")
    @Requirements(selected=true, ownership=true)
    public static void snowman(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        if (!npc.getOrAddTrait(MobType.class).getType().name().equals("SNOWMAN") && !npc.getOrAddTrait(MobType.class).getType().name().equals("SNOW_GOLEM")) {
            throw new CommandUsageException();
        }
        SnowmanTrait trait = npc.getOrAddTrait(SnowmanTrait.class);
        boolean hasArg = false;
        if (args.hasFlag('d')) {
            boolean isDerp = trait.toggleDerp();
            Messaging.sendTr(sender, isDerp ? "citizens.commands.npc.snowman.derp-set" : "citizens.commands.npc.snowman.derp-stopped", npc.getName());
            hasArg = true;
        }
        if (args.hasFlag('f')) {
            trait.setFormSnow(!trait.shouldFormSnow());
            Messaging.sendTr(sender, trait.shouldFormSnow() ? "citizens.commands.npc.snowman.form-snow-set" : "citizens.commands.npc.snowman.form-snow-stopped", npc.getName());
            hasArg = true;
        }
        if (!hasArg) {
            throw new CommandUsageException();
        }
    }
}

