/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.citizensnpcs.util.Messages;
import net.citizensnpcs.util.StringHelper;

public class Translator {
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private ResourceBundle preferredBundle;
    private final File resourceFile;
    private static Translator instance;
    public static final String PREFIX = "messages";

    private Translator(File resourceFile, Locale locale) {
        this.resourceFile = resourceFile;
        this.defaultLocale = locale;
        try {
            this.preferredBundle = ResourceBundle.getBundle(PREFIX, this.defaultLocale, new FileClassLoader(Translator.class.getClassLoader(), resourceFile));
        }
        catch (MissingResourceException e) {
            this.preferredBundle = this.getDefaultBundle();
        }
    }

    private String format(String key, Locale locale, Object ... msg) {
        String unreplaced = this.translate(key, locale);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private ResourceBundle getBundle(Locale locale) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(PREFIX, locale, new FileClassLoader(Translator.class.getClassLoader(), this.resourceFile));
            return bundle == null ? this.preferredBundle : bundle;
        }
        catch (MissingResourceException e) {
            return this.preferredBundle;
        }
    }

    private ResourceBundle getDefaultBundle() {
        return Messages.getDefaultResourceBundle(this.resourceFile, "messages_en.properties");
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    private String translate(String key, Locale locale) {
        ResourceBundle bundle = this.preferredBundle;
        if (locale != this.defaultLocale) {
            bundle = this.getBundle(locale);
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            try {
                return this.getDefaultBundle().getString(key);
            }
            catch (MissingResourceException ex) {
                return "?" + key + "?";
            }
        }
    }

    public static void setInstance(File resourceFile, Locale locale) {
        instance = new Translator(resourceFile, locale);
    }

    static String tr(String key, Locale preferredLocale, Object ... msg) {
        return StringHelper.parseColors(msg.length == 0 ? instance.translate(key, preferredLocale) : instance.format(key, preferredLocale, msg));
    }

    static String tr(String key, Object ... msg) {
        return Translator.tr(key, Translator.instance.defaultLocale, msg);
    }

    private static class FileClassLoader
    extends ClassLoader {
        private final File folder;

        public FileClassLoader(ClassLoader classLoader, File folder) {
            super(classLoader);
            this.folder = folder;
        }

        @Override
        public URL getResource(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            return super.getResource(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            File file = new File(this.folder, string);
            if (file.exists()) {
                try {
                    return new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return super.getResourceAsStream(string);
        }
    }
}

