/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.entity.Sheep;

public class Sheared
extends Trait {
    private boolean sheared;
    private final NPC npc;

    public Sheared(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.sheared = key.getBoolean("");
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("", this.sheared);
    }

    @Override
    public void onNPCSpawn() {
        if (this.npc.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setSheared(this.sheared);
        }
    }

    public boolean isSheared() {
        return this.sheared;
    }

    public void setSheared(boolean sheared) {
        this.sheared = sheared;
        if (this.npc.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setSheared(sheared);
        }
    }

    public String toString() {
        return "Sheared{" + this.sheared + "}";
    }
}

