/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Toggleable;
import net.minecraft.server.EntityHuman;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class LookClose
extends Trait
implements Runnable,
Toggleable {
    private final NPC npc;
    private boolean lookClose = Settings.Setting.DEFAULT_LOOK_CLOSE.asBoolean();

    public LookClose(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.lookClose = key.getBoolean("");
    }

    @Override
    public void run() {
        EntityHuman search = null;
        CitizensNPC handle = (CitizensNPC)this.npc;
        search = handle.getHandle().world.findNearbyPlayer((net.minecraft.server.Entity)handle.getHandle(), 5.0);
        if (search != null && this.lookClose) {
            this.faceEntity(handle, search.getBukkitEntity());
        }
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("", this.lookClose);
    }

    @Override
    public boolean toggle() {
        this.lookClose = !this.lookClose;
        return this.lookClose;
    }

    private void faceEntity(CitizensNPC npc, Entity target) {
        if (npc.getBukkitEntity().getWorld() != target.getWorld()) {
            return;
        }
        Location loc = npc.getBukkitEntity().getLocation();
        double xDiff = target.getLocation().getX() - loc.getX();
        double yDiff = target.getLocation().getY() - loc.getY();
        double zDiff = target.getLocation().getZ() - loc.getZ();
        double distanceXZ = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
        double distanceY = Math.sqrt(distanceXZ * distanceXZ + yDiff * yDiff);
        double yaw = Math.acos(xDiff / distanceXZ) * 180.0 / Math.PI;
        double pitch = Math.acos(yDiff / distanceY) * 180.0 / Math.PI - 90.0;
        if (zDiff < 0.0) {
            yaw += Math.abs(180.0 - yaw) * 2.0;
        }
        npc.getHandle().yaw = (float)yaw - 90.0f;
        npc.getHandle().pitch = (float)pitch;
        npc.getHandle().X = npc.getHandle().yaw;
    }

    public String toString() {
        return "LookClose{" + this.lookClose + "}";
    }
}

