/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.util.Messaging;

public class Settings {
    private final Storage config;
    private final DataKey root;

    public Settings(File folder) {
        this.config = new YamlStorage(new File(folder, "config.yml"), "Citizens Configuration");
        this.root = this.config.getKey("");
        this.config.load();
        for (Setting setting : Setting.values()) {
            if (!this.root.keyExists(setting.path)) {
                Messaging.logTr("citizens.settings.writing-default", setting.path);
                setting.setAtKey(this.root);
                continue;
            }
            setting.loadFromKey(this.root);
        }
        this.save();
    }

    public void reload() {
        this.config.load();
        for (Setting setting : Setting.values()) {
            if (!this.root.keyExists(setting.path)) continue;
            setting.loadFromKey(this.root);
        }
        this.save();
    }

    public void save() {
        this.config.save();
    }

    public static enum Setting {
        CHAT_PREFIX("npc.chat.prefix", "[<npc>]: "),
        DATABASE_DRIVER("storage.database.driver", ""),
        DATABASE_PASSWORD("storage.database.password", ""),
        DATABASE_URL("storage.database.url", ""),
        DATABASE_USERNAME("storage.database.username", ""),
        DEBUG_MODE("general.debug-mode", false),
        DEFAULT_LOOK_CLOSE("npc.default.look-close.enabled", false),
        DEFAULT_LOOK_CLOSE_RANGE("npc.default.look-close.range", 5),
        DEFAULT_NPC_LIMIT("npc.limits.default-limit", 10),
        DEFAULT_PATHFINDING_RANGE("npc.default.pathfinding.range", Float.valueOf(25.0f)),
        DEFAULT_RANDOM_TALKER("npc.default.random-talker", true),
        DEFAULT_REALISTIC_LOOKING("npc.default.realistic-looking", false),
        DEFAULT_STATIONARY_TICKS("npc.default.stationary-ticks", -1),
        DEFAULT_TALK_CLOSE("npc.default.talk-close.enabled", false),
        DEFAULT_TALK_CLOSE_RANGE("npc.default.talk-close.range", 5),
        DEFAULT_TEXT("npc.default.text.0", "Hi, I'm <npc>!"){

            @Override
            public void loadFromKey(DataKey root) {
                ArrayList<String> list = new ArrayList<String>();
                for (DataKey key : root.getRelative("npc.default.text").getSubKeys()) {
                    list.add(key.getString(""));
                }
                this.value = list;
            }
        }
        ,
        HIGHLIGHT_COLOUR("general.color-scheme.message-highlight", "<e>"),
        LOCALE("general.translation.locale", "en"),
        MAX_NPC_LIMIT_CHECKS("npc.limits.max-permission-checks", 100),
        MAX_SPEED("npc.limits.max-speed", 100),
        MESSAGE_COLOUR("general.color-scheme.message", "<a>"),
        NPC_COST("economy.npc.cost", 100.0),
        QUICK_SELECT("npc.selection.quick-select", false),
        REMOVE_PLAYERS_FROM_PLAYER_LIST("npc.player.remove-from-list", true),
        SAVE_TASK_DELAY("storage.save-task.delay", 72000),
        SELECTION_ITEM("npc.selection.item", "280"),
        SELECTION_MESSAGE("npc.selection.message", "<b>You selected <a><npc><b>!"),
        SERVER_OWNS_NPCS("npc.server-ownership", false),
        STORAGE_FILE("storage.file", "saves.yml"),
        STORAGE_TYPE("storage.type", "yaml"),
        SUBPLUGIN_FOLDER("subplugins.folder", "plugins"),
        TALK_CLOSE_MAXIMUM_COOLDOWN("npc.text.max-talk-cooldown", 60),
        TALK_CLOSE_MINIMUM_COOLDOWN("npc.text.min-talk-cooldown", 30),
        TALK_ITEM("npc.text.talk-item", "340");

        protected String path;
        protected Object value;

        private Setting(String path, Object value) {
            this.path = path;
            this.value = value;
        }

        public boolean asBoolean() {
            return (Boolean)this.value;
        }

        public double asDouble() {
            return ((Number)this.value).doubleValue();
        }

        public float asFloat() {
            return ((Number)this.value).floatValue();
        }

        public int asInt() {
            if (this.value instanceof String) {
                return Integer.parseInt(this.value.toString());
            }
            return ((Number)this.value).intValue();
        }

        public List<String> asList() {
            if (!(this.value instanceof List)) {
                this.value = Lists.newArrayList((Object[])new Object[]{this.value});
            }
            return (List)this.value;
        }

        public long asLong() {
            return ((Number)this.value).longValue();
        }

        public String asString() {
            return this.value.toString();
        }

        protected void loadFromKey(DataKey root) {
            this.value = root.getRaw(this.path);
        }

        protected void setAtKey(DataKey root) {
            root.setRaw(this.path, this.value);
        }
    }
}

