/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.util.Vector;

public class SwimmingNeighbourExaminer
implements BlockExaminer.ReplacementNeighbourGenerator {
    private boolean canSwimInLava;

    private void addDiagonalIfPassable(BlockSource source, PathPoint parent, List<PathPoint> out, int bx, int by, int bz, int dx, int dz) {
        if (!source.isYWithinBounds(by)) {
            return;
        }
        if (!this.isSwimCellPassable(source, bx + dx, by, bz)) {
            return;
        }
        if (!this.isSwimCellPassable(source, bx, by, bz + dz)) {
            return;
        }
        if (!this.isSwimCellPassable(source, bx + dx, by, bz + dz)) {
            return;
        }
        out.add(parent.createChild(bx + dx, by, bz + dz));
    }

    private void addIfPassable(BlockSource source, PathPoint parent, List<PathPoint> out, int x, int y, int z) {
        if (!source.isYWithinBounds(y)) {
            return;
        }
        if (!this.isSwimCellPassable(source, x, y, z)) {
            return;
        }
        out.add(parent.createChild(x, y, z));
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        return BlockExaminer.StandableState.STANDABLE;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        return 0.0f;
    }

    @Override
    public List<PathPoint> getNeighbours(BlockSource source, PathPoint point) {
        if (this.isPassable(source, point) != BlockExaminer.PassableState.PASSABLE) {
            return Collections.emptyList();
        }
        Vector base = point.getVector();
        int bx = base.getBlockX();
        int by = base.getBlockY();
        int bz = base.getBlockZ();
        ArrayList<PathPoint> out = new ArrayList<PathPoint>(10);
        this.addIfPassable(source, point, out, bx + 1, by, bz);
        this.addIfPassable(source, point, out, bx - 1, by, bz);
        this.addIfPassable(source, point, out, bx, by, bz + 1);
        this.addIfPassable(source, point, out, bx, by, bz - 1);
        this.addIfPassable(source, point, out, bx, by + 1, bz);
        this.addIfPassable(source, point, out, bx, by - 1, bz);
        this.addDiagonalIfPassable(source, point, out, bx, by, bz, 1, 1);
        this.addDiagonalIfPassable(source, point, out, bx, by, bz, 1, -1);
        this.addDiagonalIfPassable(source, point, out, bx, by, bz, -1, 1);
        this.addDiagonalIfPassable(source, point, out, bx, by, bz, -1, -1);
        return out;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector v = point.getVector();
        if (!source.isYWithinBounds(v.getBlockY())) {
            return BlockExaminer.PassableState.IMPASSABLE;
        }
        return this.isSwimCellPassable(source, v.getBlockX(), v.getBlockY(), v.getBlockZ()) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.IMPASSABLE;
    }

    private boolean isSwimCellPassable(BlockSource source, int x, int y, int z) {
        BlockData data;
        Material in = source.getMaterialAt(x, y, z);
        if (!MinecraftBlockExaminer.isLiquidOrWaterlogged(in, data = source.getBlockDataAt(x, y, z))) {
            return false;
        }
        if (MinecraftBlockExaminer.isLiquid(in)) {
            return this.isSwimmableLiquid(in);
        }
        return true;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava;
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public void setCanSwimInLava(boolean canSwimInLava) {
        this.canSwimInLava = canSwimInLava;
    }
}

