/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.ChatColor;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class AbstractNPC
implements NPC {
    private Character character;
    private final int id;
    private String name;
    protected final List<Runnable> runnables = new ArrayList<Runnable>();
    protected final Map<Class<? extends Trait>, Trait> traits = new HashMap<Class<? extends Trait>, Trait>();
    private static final MetadataStoreBase<NPC> METADATA = new MetadataStoreBase<NPC>(){

        protected String disambiguate(NPC subject, String metadataKey) {
            return Integer.toString(subject.getId()) + ":" + subject.getName() + ":" + metadataKey;
        }
    };

    protected AbstractNPC(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Character getCharacter() {
        return this.character;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public List<MetadataValue> getMetadata(String key) {
        return METADATA.getMetadata((Object)this, key);
    }

    @Override
    public String getName() {
        String parsed = this.name;
        for (ChatColor color : ChatColor.values()) {
            if (!parsed.contains("<" + color.getChar() + ">")) continue;
            parsed = parsed.replace("<" + color.getChar() + ">", "");
        }
        return parsed;
    }

    @Override
    public Iterable<Trait> getTraits() {
        return Collections.unmodifiableCollection(this.traits.values());
    }

    public boolean hasMetadata(String key) {
        return METADATA.hasMetadata((Object)this, key);
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public void remove() {
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            if (!(trait instanceof Listener)) continue;
            HandlerList.unregisterAll((Listener)((Listener)trait));
        }
        this.traits.clear();
    }

    public void removeMetadata(String key, Plugin plugin) {
        METADATA.removeMetadata((Object)this, key, plugin);
    }

    @Override
    public void removeTrait(Class<? extends Trait> trait) {
        if (this.traits.containsKey(trait)) {
            Trait t = this.traits.get(trait);
            if (t instanceof Runnable) {
                this.runnables.remove(t);
            }
            t.onRemove();
        }
        this.traits.remove(trait);
    }

    @Override
    public void setCharacter(Character character) {
        if (this.character != null) {
            if (this.character instanceof Runnable) {
                this.runnables.remove(this.character);
            }
            this.character.onRemove(this);
        }
        this.character = character;
        if (character != null) {
            if (character instanceof Runnable) {
                this.runnables.add((Runnable)((Object)character));
            }
            character.onSet(this);
        }
    }

    public void setMetadata(String key, MetadataValue value) {
        METADATA.setMetadata((Object)this, key, value);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
    }
}

