/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.event.NPCSelectEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCManager;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHandle;
import net.citizensnpcs.util.ByIdArray;
import net.citizensnpcs.util.NPCBuilder;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class CitizensNPCManager
implements NPCManager {
    private final NPCBuilder npcBuilder = new NPCBuilder();
    private final ByIdArray<NPC> npcs = new ByIdArray();
    private final Citizens plugin;
    private final Storage saves;

    public CitizensNPCManager(Citizens plugin, Storage saves) {
        this.plugin = plugin;
        this.saves = saves;
    }

    public NPC createNPC(EntityType type, int id, String name, Character character) {
        CitizensNPC npc = this.npcBuilder.getByType(type, this, id, name);
        npc.setCharacter(character);
        this.npcs.put(npc.getId(), npc);
        return npc;
    }

    @Override
    public NPC createNPC(EntityType type, String name) {
        return this.createNPC(type, name, null);
    }

    @Override
    public NPC createNPC(EntityType type, String name, Character character) {
        return this.createNPC(type, this.generateUniqueId(), name, character);
    }

    public void despawn(NPC npc, boolean keepSelected) {
        if (!keepSelected) {
            npc.removeMetadata("selectors", (Plugin)this.plugin);
        }
        npc.getBukkitEntity().remove();
    }

    private int generateUniqueId() {
        int count = 0;
        while (this.getNPC(count++) != null) {
        }
        return count - 1;
    }

    @Override
    public NPC getNPC(Entity entity) {
        net.minecraft.server.Entity handle = ((CraftEntity)entity).getHandle();
        if (handle instanceof NPCHandle) {
            return ((NPCHandle)handle).getNPC();
        }
        for (NPC npc : this.npcs) {
            if (!npc.isSpawned() || npc.getBukkitEntity().getEntityId() != entity.getEntityId()) continue;
            return npc;
        }
        return null;
    }

    @Override
    public NPC getNPC(int id) {
        return this.npcs.get(id);
    }

    @Override
    public Collection<NPC> getNPCs(Class<? extends Character> character) {
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        for (NPC npc : this) {
            if (npc.getCharacter() == null || !npc.getCharacter().getClass().equals(character)) continue;
            npcs.add(npc);
        }
        return npcs;
    }

    @Override
    public boolean isNPC(Entity entity) {
        return this.getNPC(entity) != null;
    }

    @Override
    public Iterator<NPC> iterator() {
        return this.npcs.iterator();
    }

    public void remove(NPC npc) {
        this.npcs.remove(npc.getId());
        this.saves.getKey("npc").removeKey(String.valueOf(npc.getId()));
        this.removeMetadata(npc);
    }

    public void safeRemove() throws NPCLoadException {
        while (this.iterator().hasNext()) {
            NPC npc = this.iterator().next();
            this.removeMetadata(npc);
            npc.despawn();
            this.iterator().remove();
        }
    }

    public void removeAll() {
        while (this.iterator().hasNext()) {
            this.iterator().next().remove();
        }
    }

    public void selectNPC(Player player, NPC npc) {
        if (player.hasMetadata("selected")) {
            player.removeMetadata("selected", (Plugin)this.plugin);
        }
        player.setMetadata("selected", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)npc.getId()));
        npc.setMetadata("selectors", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)player.getName()));
        Editor.leave(player);
        player.getServer().getPluginManager().callEvent((Event)new NPCSelectEvent(npc, player));
    }

    private void removeMetadata(NPC npc) {
        if (npc.hasMetadata("selectors")) {
            for (MetadataValue value : npc.getMetadata("selectors")) {
                if (Bukkit.getPlayer((String)value.asString()) == null) continue;
                Bukkit.getPlayer((String)value.asString()).removeMetadata("selected", (Plugin)this.plugin);
            }
            npc.removeMetadata("selectors", (Plugin)this.plugin);
        }
    }
}

