/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMS;
import org.bukkit.entity.Entity;

@TraitName(value="mounttrait")
public class MountTrait
extends Trait {
    private UUID currentMount;
    @Persist(value="mountedon")
    private UUID uuid;

    public MountTrait() {
        super("mounttrait");
    }

    public void checkMounted() {
        if (this.uuid == null || this.uuid.equals(this.currentMount)) {
            return;
        }
        NPC other = CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(this.uuid);
        if (other != null && other.isSpawned()) {
            NMS.mount(other.getEntity(), this.npc.getEntity());
            this.currentMount = this.uuid;
        }
    }

    public UUID getMountedOn() {
        return this.currentMount;
    }

    @Override
    public void onDespawn() {
        if (this.currentMount != null) {
            this.npc.getEntity().leaveVehicle();
            this.currentMount = null;
        }
    }

    @Override
    public void onRemove() {
        this.onDespawn();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        Entity vehicle = NMS.getVehicle(this.npc.getEntity());
        if (vehicle == null && this.currentMount != null) {
            this.currentMount = null;
        } else if (vehicle instanceof NPCHolder) {
            this.setMountedOn(((NPCHolder)vehicle).getNPC().getUniqueId());
        }
        this.checkMounted();
    }

    public void setMountedOn(UUID uuid) {
        this.uuid = uuid;
        if (this.npc.isSpawned()) {
            this.checkMounted();
        }
    }

    public void unmount() {
        if (this.currentMount == null) {
            return;
        }
        this.onDespawn();
        this.uuid = null;
    }
}

