/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitEventHandler;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredListener;

public final class TraitInfo {
    private boolean defaultTrait;
    private String name;
    private Supplier<? extends Trait> supplier;
    private boolean trackStats;
    private final Class<? extends Trait> trait;

    private TraitInfo(Class<? extends Trait> trait) {
        this.trait = trait;
        TraitName anno = trait.getAnnotation(TraitName.class);
        if (anno != null) {
            this.name = anno.value().toLowerCase(Locale.ROOT);
        }
        try {
            Constructor<? extends Trait> cons = trait.getDeclaredConstructor(new Class[0]);
            cons.setAccessible(true);
            this.supplier = () -> {
                try {
                    return (Trait)cons.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            };
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
    }

    public TraitInfo asDefaultTrait() {
        this.defaultTrait = true;
        return this;
    }

    public void checkValid() {
        if (this.supplier == null) {
            try {
                this.trait.getConstructor(new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Trait class must have a no-arguments constructor");
            }
        }
    }

    public Class<? extends Trait> getTraitClass() {
        return this.trait;
    }

    public String getTraitName() {
        return this.name;
    }

    public boolean isDefaultTrait() {
        return this.defaultTrait;
    }

    public TraitInfo optInToStats() {
        this.trackStats = true;
        return this;
    }

    public void registerListener(Plugin plugin) {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Method method : this.trait.getDeclaredMethods()) {
            TraitEventHandler.NPCEventExtractor processor;
            TraitEventHandler sel = method.getAnnotation(TraitEventHandler.class);
            if (sel == null) continue;
            try {
                processor = sel.processor() != TraitEventHandler.NPCEventExtractor.class ? sel.processor().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : event -> {
                    if (event instanceof NPCEvent) {
                        return ((NPCEvent)((Object)event)).getNPC();
                    }
                    if (event instanceof EntityEvent) {
                        return CitizensAPI.getNPCRegistry().getNPC(((EntityEvent)event).getEntity());
                    }
                    return null;
                };
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            Class<?> eventClass = method.getParameterTypes()[0];
            try {
                HandlerList handler = null;
                for (Field field : eventClass.getDeclaredFields()) {
                    if (field.getType() != HandlerList.class || !Modifier.isStatic(field.getModifiers())) continue;
                    field.setAccessible(true);
                    handler = (HandlerList)field.get(null);
                }
                if (handler == null) {
                    Messaging.severe("Can't get handlerlist for event " + eventClass);
                    continue;
                }
                method.setAccessible(true);
                MethodHandle asMethodHandle = lookup.unreflect(method);
                handler.register(new RegisteredListener(new Listener(){}, (listener, event) -> {
                    NPC npc = (NPC)processor.apply(event);
                    if (npc == null) {
                        return;
                    }
                    Trait instance = npc.getTraitNullable(this.trait);
                    if (instance == null) {
                        return;
                    }
                    try {
                        asMethodHandle.invoke(instance, event);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }, sel.value().priority(), plugin, sel.value().ignoreCancelled()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldTrackStats() {
        return this.trackStats;
    }

    public <T extends Trait> T tryCreateInstance() {
        return (T)this.supplier.get();
    }

    public TraitInfo withName(String name) {
        Objects.requireNonNull(name);
        this.name = name.toLowerCase(Locale.ROOT);
        return this;
    }

    public TraitInfo withSupplier(Supplier<? extends Trait> supplier) {
        this.supplier = supplier;
        return this;
    }

    public static TraitInfo create(Class<? extends Trait> trait) {
        Objects.requireNonNull(trait);
        return new TraitInfo(trait);
    }
}

