/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.api.ai.AbstractPathStrategy;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.util.Vector;

public class StraightLineNavigationStrategy
extends AbstractPathStrategy {
    private Location destination;
    private final NPC npc;
    private final NavigatorParameters params;
    private Entity target;

    public StraightLineNavigationStrategy(NPC npc, Entity target, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.target = target;
        this.npc = npc;
        this.destination = params.entityTargetLocationMapper().apply(target);
    }

    public StraightLineNavigationStrategy(NPC npc, Location dest, NavigatorParameters params) {
        super(TargetType.LOCATION);
        this.params = params;
        this.destination = dest;
        this.npc = npc;
    }

    @Override
    public Location getCurrentDestination() {
        return this.destination;
    }

    @Override
    public Iterable<Vector> getPath() {
        return null;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.destination;
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean update() {
        if (this.getCancelReason() != null || this.npc.getStoredLocation().getWorld() != this.destination.getWorld()) {
            return true;
        }
        Location currLoc = this.npc.getEntity().getLocation();
        if (currLoc.distance(this.destination) <= this.params.distanceMargin()) {
            if (this.npc.isFlyable()) {
                this.npc.getEntity().setVelocity(new Vector(0, 0, 0));
            }
            return true;
        }
        if (this.target != null) {
            this.destination = this.params.entityTargetLocationMapper().apply(this.target);
        }
        Vector destVector = currLoc.toVector().add(this.destination.toVector().subtract(currLoc.toVector()).normalize());
        Location destLoc = destVector.toLocation(this.destination.getWorld());
        if (!this.npc.isFlyable() && destVector.getBlockY() > currLoc.getBlockY()) {
            Block block = destLoc.getBlock();
            while (block.getY() > currLoc.getBlockY() && !MinecraftBlockExaminer.canStandOn(block.getRelative(BlockFace.DOWN))) {
                if ((block = block.getRelative(BlockFace.DOWN)).getY() > 0) continue;
                block = destLoc.getBlock();
                break;
            }
            destLoc = block.getLocation();
            destVector = destLoc.toVector();
        }
        double dX = destVector.getX() - currLoc.getX();
        double dZ = destVector.getZ() - currLoc.getZ();
        double dY = destVector.getY() - currLoc.getY();
        double xzDistance = dX * dX + dZ * dZ;
        double distance = xzDistance + dY * dY;
        if (this.npc.isFlyable()) {
            float normalisedTargetYaw;
            Vector velocity = this.npc.getEntity().getVelocity();
            double motX = velocity.getX();
            double motY = velocity.getY();
            double motZ = velocity.getZ();
            motX += (Math.signum(dX) * 0.5 - motX) * 0.1;
            motY += (Math.signum(dY) - motY) * 0.1;
            motZ += (Math.signum(dZ) * 0.5 - motZ) * 0.1;
            velocity.setX(motX).setY(motY).setZ(motZ).multiply(this.params.speed());
            this.npc.getEntity().setVelocity(velocity);
            float targetYaw = (float)(Math.atan2(motZ, motX) * 180.0 / Math.PI) - 90.0f;
            for (normalisedTargetYaw = targetYaw - currLoc.getYaw(); normalisedTargetYaw >= 180.0f; normalisedTargetYaw -= 360.0f) {
            }
            while (normalisedTargetYaw < -180.0f) {
                normalisedTargetYaw += 360.0f;
            }
            if (this.npc.getEntity().getType() != EntityType.ENDER_DRAGON) {
                NMS.setVerticalMovement(this.npc.getEntity(), 0.5);
                NMS.setHeadAndBodyYaw(this.npc.getEntity(), currLoc.getYaw() + normalisedTargetYaw);
            }
        } else if (this.npc.getEntity() instanceof LivingEntity) {
            NMS.setDestination(this.npc.getEntity(), destVector.getX(), destVector.getY(), destVector.getZ(), this.params.speedModifier());
        } else {
            Vector dir = destVector.subtract(currLoc.toVector()).normalize().multiply(0.2);
            Block in = currLoc.getBlock();
            if (distance > 0.0 && dY >= 1.0 && xzDistance <= 2.75 || dY >= 0.2 && MinecraftBlockExaminer.isLiquidOrWaterlogged(in)) {
                dir.add(new Vector(0.0, 0.75, 0.0));
            }
            Util.faceLocation(this.npc.getEntity(), destLoc);
            this.npc.getEntity().setVelocity(dir);
        }
        return false;
    }
}

