/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar.pathfinder;

import net.citizensnpcs.api.astar.pathfinder.BlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.MinecraftBlockExaminer;
import net.citizensnpcs.api.astar.pathfinder.PathPoint;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.SpigotUtil;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Squid;
import org.bukkit.entity.WaterMob;
import org.bukkit.util.Vector;

public class SwimmingExaminer
implements BlockExaminer {
    private boolean canSwimInLava;
    private final NPC npc;
    private static final Vector UP = new Vector(0, 1, 0);

    public SwimmingExaminer(NPC npc) {
        this.npc = npc;
    }

    @Override
    public BlockExaminer.StandableState canStandAt(BlockSource source, PathPoint point) {
        Vector pos = point.getVector();
        Material in = source.getMaterialAt(pos);
        if (MinecraftBlockExaminer.isLiquidOrWaterlogged(in, source.getBlockDataAt(pos))) {
            return BlockExaminer.StandableState.STANDABLE;
        }
        return BlockExaminer.StandableState.IGNORE;
    }

    public boolean canSwimInLava() {
        return this.canSwimInLava;
    }

    @Override
    public float getCost(BlockSource source, PathPoint point) {
        if (!SwimmingExaminer.isWaterMob(this.npc.getEntity())) {
            return 0.0f;
        }
        if (!MinecraftBlockExaminer.isLiquidOrWaterlogged(source.getMaterialAt(point.getVector()), source.getBlockDataAt(point.getVector()))) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public BlockExaminer.PassableState isPassable(BlockSource source, PathPoint point) {
        Vector vector = point.getVector();
        if (!MinecraftBlockExaminer.isLiquidOrWaterlogged(source.getMaterialAt(vector), source.getBlockDataAt(vector))) {
            return BlockExaminer.PassableState.IGNORE;
        }
        if (SwimmingExaminer.isWaterMob(this.npc.getEntity())) {
            return BlockExaminer.PassableState.PASSABLE;
        }
        Vector above = vector.clone().add(UP);
        Material aboveMat = source.getMaterialAt(above);
        return this.isSwimmableLiquid(aboveMat) || MinecraftBlockExaminer.canStandIn(aboveMat, source.getBlockDataAt(above)) ? BlockExaminer.PassableState.PASSABLE : BlockExaminer.PassableState.IMPASSABLE;
    }

    private boolean isSwimmableLiquid(Material material) {
        if (material == Material.LAVA || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_LAVA")) {
            return this.canSwimInLava();
        }
        return material == Material.WATER || !SpigotUtil.isUsing1_13API() && material == Material.valueOf((String)"STATIONARY_WATER");
    }

    public void setCanSwimInLava(boolean canSwimInLava) {
        this.canSwimInLava = canSwimInLava;
    }

    public static boolean isWaterMob(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (!SpigotUtil.isUsing1_13API()) {
            return entity instanceof Squid;
        }
        return entity instanceof WaterMob || entity.getType().name().equals("TURTLE") || entity.getType().name().equals("FROG") || entity.getType().name().equals("AXOLOTL");
    }
}

