/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.citizensnpcs.api.util.DataKey;

public class MemoryDataKey
extends DataKey {
    private final String name;
    private final Map<String, Object> root;
    private static final char INTERNAL_SEPARATOR = '\u0000';
    private static final Splitter INTERNAL_SEPARATOR_SPLITTER = Splitter.on((char)'\u0000');

    public MemoryDataKey() {
        this(new HashMap<String, Object>(), "", "");
    }

    public MemoryDataKey(Map<String, Object> root) {
        this(root, "", "");
    }

    private MemoryDataKey(Map<String, Object> root, String path, String name) {
        super(path);
        this.root = root;
        this.name = name;
    }

    @Override
    public MemoryDataKey copy() {
        return new MemoryDataKey(this.deepCopyMap(this.getCurrentSection()), "", "");
    }

    private Map<String, Object> deepCopyMap(Map<String, Object> source) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)source.size());
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                result.put(entry.getKey(), this.deepCopyMap((Map)value));
                continue;
            }
            result.put(entry.getKey(), value);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MemoryDataKey other = (MemoryDataKey)obj;
        return Objects.equals(this.getDisplayPath(), other.getDisplayPath()) && this.root == other.root;
    }

    @Override
    public boolean getBoolean(String key) {
        Object value = this.getRaw(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    private Map<String, Object> getCurrentSection() {
        String[] segments;
        if (this.path.isEmpty()) {
            return this.root;
        }
        Map current = this.root;
        for (String segment : segments = this.path.split("\\\u0000")) {
            Object next = current.get(segment);
            if (!(next instanceof Map)) {
                return Collections.emptyMap();
            }
            current = (Map)next;
        }
        return current;
    }

    private String getDisplayPath() {
        return this.path.replace('\u0000', '.');
    }

    @Override
    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    @Override
    public double getDouble(String key, double def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Double res = Doubles.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public DataKey getFromRoot(String path) {
        return this.navigatePath(this.root, "", path);
    }

    @Override
    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    @Override
    public int getInt(String key, int def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Integer res = Ints.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    @Override
    public long getLong(String key, long def) {
        String raw;
        Object value = this.getRaw(key);
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value != null && !(raw = value.toString()).isEmpty()) {
            Long res = Longs.tryParse((String)raw);
            return res != null ? res : def;
        }
        return def;
    }

    @Override
    public String getPath() {
        return this.getDisplayPath();
    }

    @Override
    public Object getRaw(String key) {
        if (key == null || key.isEmpty()) {
            return this.getValueAtCurrentPath();
        }
        return this.navigateToValue(key);
    }

    @Override
    public MemoryDataKey getRelative(String relative) {
        if (relative == null || relative.isEmpty()) {
            return this;
        }
        return this.navigatePath(this.root, this.path, relative);
    }

    @Override
    public String getString(String key) {
        Object val = this.getRaw(key);
        if (val != null && !(val instanceof Map)) {
            return val.toString();
        }
        return "";
    }

    @Override
    public Iterable<DataKey> getSubKeys() {
        Map<String, Object> current = this.getCurrentSection();
        if (current == null || current.isEmpty()) {
            return Collections.emptyList();
        }
        return current.keySet().stream().map(k -> {
            String newPath = this.path.isEmpty() ? k : this.path + '\u0000' + k;
            return new MemoryDataKey(this.root, newPath, (String)k);
        }).collect(Collectors.toList());
    }

    private Object getValueAtCurrentPath() {
        if (this.path.isEmpty()) {
            return this.root;
        }
        Map current = this.root;
        String[] segments = this.path.split("\\\u0000");
        for (int i = 0; i < segments.length - 1; ++i) {
            Object next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                return null;
            }
            current = (Map)next;
        }
        return current.get(segments[segments.length - 1]);
    }

    @Override
    public Map<String, Object> getValuesDeep() {
        Map<String, Object> section = this.getCurrentSection();
        if (section == null) {
            return Collections.emptyMap();
        }
        return this.deepCopyMap(section);
    }

    @Override
    public int hashCode() {
        String displayPath = this.getDisplayPath();
        return 31 * (displayPath == null ? 0 : displayPath.hashCode()) + System.identityHashCode(this.root);
    }

    @Override
    public boolean hasSubKeys() {
        Map<String, Object> current = this.getCurrentSection();
        return current != null && !current.isEmpty();
    }

    @Override
    public boolean keyExists(String key) {
        if (key == null || key.isEmpty()) {
            return !this.getCurrentSection().isEmpty();
        }
        return this.navigateToValue(key) != null;
    }

    @Override
    public String name() {
        return this.name;
    }

    private MemoryDataKey navigatePath(Map<String, Object> root, String currentInternalPath, String relativePath) {
        String[] pathParts = relativePath.split("\\.");
        StringBuilder newInternalPath = new StringBuilder(currentInternalPath);
        for (String part : pathParts) {
            if (newInternalPath.length() > 0) {
                newInternalPath.append('\u0000');
            }
            newInternalPath.append(part);
        }
        String lastName = pathParts[pathParts.length - 1];
        return new MemoryDataKey(root, newInternalPath.toString(), lastName);
    }

    private Object navigateToValue(String relativePath) {
        Map current = this.getCurrentSection();
        if (current == null) {
            return null;
        }
        String[] segments = relativePath.split("\\.");
        for (int i = 0; i < segments.length - 1; ++i) {
            Object next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                return null;
            }
            current = (Map)next;
        }
        return current.get(segments[segments.length - 1]);
    }

    @Override
    public void removeKey(String key) {
        this.setRaw(key, null);
    }

    @Override
    public void setBoolean(String key, boolean value) {
        this.setRaw(key, value);
    }

    @Override
    public void setDouble(String key, double value) {
        this.setRaw(key, value);
    }

    @Override
    public void setInt(String key, int value) {
        this.setRaw(key, value);
    }

    @Override
    public void setLong(String key, long value) {
        this.setRaw(key, value);
    }

    @Override
    public void setMap(String key, Map<String, Object> value) {
        this.setRaw(key, value);
    }

    @Override
    public void setRaw(String key, Object value) {
        String fullInternalPath = key == null || key.isEmpty() ? this.path : (this.path.isEmpty() ? key.replace('.', '\u0000') : this.path + '\u0000' + key.replace('.', '\u0000'));
        if (fullInternalPath.isEmpty()) {
            if (value == null) {
                this.root.clear();
            } else if (value instanceof Map) {
                this.root.clear();
                this.root.putAll((Map)value);
            }
            throw new IllegalStateException("Unsupported root value");
        }
        String[] segments = fullInternalPath.split("\\\u0000");
        Map current = this.root;
        for (int i = 0; i < segments.length - 1; ++i) {
            HashMap next = current.get(segments[i]);
            if (!(next instanceof Map)) {
                if (value == null) {
                    return;
                }
                next = new HashMap();
                current.put(segments[i], next);
            }
            current = next;
        }
        String lastSegment = segments[segments.length - 1];
        if (value == null) {
            current.remove(lastSegment);
        } else {
            current.put(lastSegment, value);
        }
    }

    @Override
    public void setString(String key, String value) {
        this.setRaw(key, value);
    }

    public String toString() {
        return "MemoryDataKey[" + this.getDisplayPath() + "]";
    }
}

