/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_20_R4.util;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.Settings;
import net.citizensnpcs.nms.v1_20_R4.util.EntityJumpControl;
import net.citizensnpcs.nms.v1_20_R4.util.EntityMoveControl;
import net.citizensnpcs.nms.v1_20_R4.util.EntityNavigation;
import net.citizensnpcs.nms.v1_20_R4.util.NMSImpl;
import org.bukkit.entity.Entity;

public interface MobAI {
    public Entity getBukkitEntity();

    public bzq getJumpControl();

    public Map<eoo, Float> getMalus();

    public bzs getMoveControl();

    public cdd getNavigation();

    default public float getPathfindingMalus(eoo var1) {
        Map<eoo, Float> malus = this.getMalus();
        return malus.containsKey(var1) ? malus.get(var1).floatValue() : var1.a();
    }

    default public void setPathfindingMalus(eoo water, float oldWaterCost) {
        this.getMalus().put(water, Float.valueOf(oldWaterCost));
    }

    default public void tickAI() {
        this.getJumpControl().b();
        this.getMoveControl().a();
        cdd nav = this.getNavigation();
        if (!nav.l()) {
            nav.c();
        }
    }

    default public void updatePathfindingRange(float range) {
        ((btr)NMSImpl.getHandle(this.getBukkitEntity())).f(buz.k).a((double)range);
    }

    public static MobAI from(bsw handle) {
        if (handle instanceof btt) {
            final btt mob = (btt)handle;
            return new MobAI(){

                @Override
                public Entity getBukkitEntity() {
                    return mob.getBukkitEntity();
                }

                @Override
                public bzq getJumpControl() {
                    return mob.I();
                }

                @Override
                public Map<eoo, Float> getMalus() {
                    return null;
                }

                @Override
                public bzs getMoveControl() {
                    return mob.H();
                }

                @Override
                public cdd getNavigation() {
                    return mob.K();
                }

                @Override
                public float getPathfindingMalus(eoo var1) {
                    return mob.a(var1);
                }

                @Override
                public void setPathfindingMalus(eoo water, float oldWaterCost) {
                    mob.a(water, oldWaterCost);
                }

                @Override
                public void tickAI() {
                    mob.M().a();
                    mob.K().c();
                    mob.H().a();
                    mob.G().a();
                    mob.I().b();
                }
            };
        }
        if (handle instanceof MobAI) {
            return (MobAI)handle;
        }
        return null;
    }

    public static interface ForwardingMobAI
    extends MobAI {
        public MobAI getAI();

        @Override
        default public Entity getBukkitEntity() {
            return this.getAI().getBukkitEntity();
        }

        @Override
        default public bzq getJumpControl() {
            return this.getAI().getJumpControl();
        }

        @Override
        default public Map<eoo, Float> getMalus() {
            return this.getAI().getMalus();
        }

        @Override
        default public bzs getMoveControl() {
            return this.getAI().getMoveControl();
        }

        @Override
        default public cdd getNavigation() {
            return this.getAI().getNavigation();
        }
    }

    public static class BasicMobAI
    implements MobAI {
        private final EntityJumpControl controllerJump;
        private final EntityMoveControl controllerMove;
        private final btr entity;
        private final Map<eoo, Float> malus;
        private final EntityNavigation navigation;

        public BasicMobAI(btr entity) {
            this.entity = entity;
            NMSImpl.setAttribute(entity, (ji<buu>)buz.k, Settings.Setting.DEFAULT_PATHFINDING_RANGE.asDouble());
            entity.f(buz.r).a(0.3);
            this.controllerJump = new EntityJumpControl(entity);
            this.controllerMove = new EntityMoveControl(entity);
            this.navigation = new EntityNavigation(entity, entity.dP());
            this.malus = Maps.newEnumMap(eoo.class);
        }

        @Override
        public Entity getBukkitEntity() {
            return this.entity.getBukkitEntity();
        }

        @Override
        public bzq getJumpControl() {
            return this.controllerJump;
        }

        @Override
        public Map<eoo, Float> getMalus() {
            return this.malus;
        }

        @Override
        public bzs getMoveControl() {
            return this.controllerMove;
        }

        @Override
        public cdd getNavigation() {
            return this.navigation;
        }
    }
}

