/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ListResourceBundle;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import net.citizensnpcs.api.CitizensAPI;

public enum Messages {

    private String defaultTranslation;
    private String key;
    private static ResourceBundle defaultBundle;

    private Messages(String key, String defaultTranslation) {
        this.key = key;
        this.defaultTranslation = defaultTranslation;
    }

    public String getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceBundle getDefaultResourceBundle() {
        if (defaultBundle == null) {
            File dir = new File(CitizensAPI.getDataFolder(), "i18n");
            dir.mkdirs();
            File bundleFile = new File(dir, "messages_en.properties");
            if (!bundleFile.exists()) {
                Messages.populateDefaults(bundleFile);
            }
            FileInputStream stream = null;
            try {
                stream = new FileInputStream(bundleFile);
                defaultBundle = new PropertyResourceBundle(stream);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    defaultBundle = Messages.getFallbackResourceBundle();
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(stream);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)stream);
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        return defaultBundle;
    }

    private static ResourceBundle getFallbackResourceBundle() {
        return new ListResourceBundle(){

            @Override
            protected Object[][] getContents() {
                Messages[] values = Messages.values();
                Object[][] contents = new Object[values.length][2];
                for (int i = 0; i < values.length; ++i) {
                    Messages message = values[i];
                    contents[i] = new Object[]{message.key, message.defaultTranslation};
                }
                return contents;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateDefaults(File bundleFile) {
        Properties properties = new Properties();
        for (Messages message : Messages.values()) {
            properties.put(message.key, message.defaultTranslation);
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(bundleFile);
            properties.store(stream, "");
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
        }
        Closeables.closeQuietly((Closeable)stream);
    }
}

