/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import net.citizensnpcs.Settings;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigationBeginEvent;
import net.citizensnpcs.api.ai.event.NavigationCancelEvent;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.ai.event.NavigationReplaceEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

public class CitizensNavigator
implements Navigator {
    private final NavigatorParameters defaultParams;
    private PathStrategy executing;
    private int lastX;
    private int lastY;
    private int lastZ;
    private NavigatorParameters localParams;
    private final CitizensNPC npc;
    private int stationaryTicks;
    private boolean updatedAvoidWater;
    private static int UNINITIALISED_SPEED = Integer.MIN_VALUE;

    public CitizensNavigator(CitizensNPC npc) {
        this.localParams = this.defaultParams = new NavigatorParameters().baseSpeed(UNINITIALISED_SPEED).range(Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()).stationaryTicks(Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt());
        this.updatedAvoidWater = false;
        this.npc = npc;
    }

    @Override
    public void cancelNavigation() {
        this.stopNavigating(CancelReason.PLUGIN);
    }

    @Override
    public NavigatorParameters getDefaultParameters() {
        return this.defaultParams;
    }

    @Override
    public EntityTarget getEntityTarget() {
        return this.executing instanceof EntityTarget ? (EntityTarget)((Object)this.executing) : null;
    }

    @Override
    public NavigatorParameters getLocalParameters() {
        if (!this.isNavigating()) {
            throw new IllegalStateException("not navigating");
        }
        return this.localParams;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    @Override
    public Location getTargetAsLocation() {
        return this.isNavigating() ? this.executing.getTargetAsLocation() : null;
    }

    @Override
    public TargetType getTargetType() {
        return this.isNavigating() ? this.executing.getTargetType() : null;
    }

    @Override
    public boolean isNavigating() {
        return this.executing != null;
    }

    public void load(DataKey root) {
        this.defaultParams.baseSpeed((float)root.getDouble("speed", UNINITIALISED_SPEED));
        this.defaultParams.range((float)root.getDouble("pathfindingrange", Settings.Setting.DEFAULT_PATHFINDING_RANGE.asFloat()));
        this.defaultParams.stationaryTicks(root.getInt("stationaryticks", Settings.Setting.DEFAULT_STATIONARY_TICKS.asInt()));
        this.defaultParams.speedModifier((float)root.getDouble("speedmodifier", 1.0));
        if (root.keyExists("avoidwater")) {
            this.defaultParams.avoidWater(root.getBoolean("avoidwater"));
        }
    }

    public void onSpawn() {
        if (this.defaultParams.baseSpeed() == (float)UNINITIALISED_SPEED) {
            this.defaultParams.baseSpeed(NMS.getSpeedFor(this.npc.getHandle()));
        }
        this.updatePathfindingRange();
        if (!this.updatedAvoidWater) {
            boolean defaultAvoidWater = this.npc.getHandle().getNavigation().a();
            this.defaultParams.avoidWater(defaultAvoidWater);
            this.updatedAvoidWater = true;
        }
    }

    public void save(DataKey root) {
        root.setDouble("speed", this.defaultParams.baseSpeed());
        root.setDouble("pathfindingrange", this.defaultParams.range());
        root.setInt("stationaryticks", this.defaultParams.stationaryTicks());
        root.setDouble("speedmodifier", this.defaultParams.speedModifier());
        root.setBoolean("avoidwater", this.defaultParams.avoidWater());
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.localParams = this.defaultParams.clone();
        MCTargetStrategy newStrategy = new MCTargetStrategy(this.npc, target, aggressive, this.localParams);
        this.switchStrategyTo(newStrategy);
    }

    @Override
    public void setTarget(Location target) {
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (target == null) {
            this.cancelNavigation();
            return;
        }
        this.localParams = this.defaultParams.clone();
        MCNavigationStrategy newStrategy = new MCNavigationStrategy(this.npc, target, this.localParams);
        this.switchStrategyTo(newStrategy);
    }

    private void stopNavigating() {
        if (this.executing != null) {
            this.executing.stop();
        }
        this.executing = null;
        this.localParams = this.defaultParams;
        this.stationaryTicks = 0;
        if (this.npc.isSpawned()) {
            EntityLiving entity = this.npc.getHandle();
            entity.motZ = 0.0;
            entity.motY = 0.0;
            entity.motX = 0.0;
        }
    }

    private void stopNavigating(CancelReason reason) {
        boolean shouldContinue;
        StuckAction action;
        if (!this.isNavigating()) {
            return;
        }
        if (reason == CancelReason.STUCK && (action = this.localParams.stuckAction()) != null && (shouldContinue = action.run(this.npc, this))) {
            this.stationaryTicks = 0;
            this.executing.clearCancelReason();
            return;
        }
        NavigationCancelEvent event = new NavigationCancelEvent(this, reason);
        PathStrategy old = this.executing;
        Bukkit.getPluginManager().callEvent((Event)event);
        if (old == this.executing) {
            this.stopNavigating();
        }
    }

    private void switchStrategyTo(PathStrategy newStrategy) {
        if (this.executing != null) {
            Bukkit.getPluginManager().callEvent((Event)new NavigationReplaceEvent(this));
        }
        this.executing = newStrategy;
        this.stationaryTicks = 0;
        Bukkit.getPluginManager().callEvent((Event)new NavigationBeginEvent(this));
    }

    public void update() {
        if (!this.isNavigating()) {
            return;
        }
        if (!this.npc.isSpawned()) {
            this.stopNavigating(CancelReason.NPC_DESPAWNED);
            return;
        }
        if (this.updateStationaryStatus()) {
            return;
        }
        this.updatePathfindingRange();
        boolean finished = this.executing.update();
        if (!finished) {
            return;
        }
        if (this.executing.getCancelReason() != null) {
            this.stopNavigating(this.executing.getCancelReason());
        } else {
            NavigationCompleteEvent event = new NavigationCompleteEvent(this);
            PathStrategy old = this.executing;
            Bukkit.getPluginManager().callEvent((Event)event);
            if (old == this.executing) {
                this.stopNavigating();
            }
        }
    }

    private void updatePathfindingRange() {
        NMS.updatePathfindingRange(this.npc, this.localParams.range());
    }

    private boolean updateStationaryStatus() {
        if (this.localParams.stationaryTicks() < 0) {
            return false;
        }
        EntityLiving handle = this.npc.getHandle();
        if (this.lastX == (int)handle.locX && this.lastY == (int)handle.locY && this.lastZ == (int)handle.locZ) {
            if (++this.stationaryTicks >= this.localParams.stationaryTicks()) {
                this.stopNavigating(CancelReason.STUCK);
                return true;
            }
        } else {
            this.stationaryTicks = 0;
        }
        this.lastX = (int)handle.locX;
        this.lastY = (int)handle.locY;
        this.lastZ = (int)handle.locZ;
        return false;
    }
}

