/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.GoalSelector;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.event.NavigationCompleteEvent;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.EntityEnderCrystalMarker;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class LinearWaypointProvider
implements WaypointProvider {
    private LinearWaypointGoal currentGoal;
    private NPC npc;
    private final List<Waypoint> waypoints = Lists.newArrayList();
    private static final Function<Waypoint, Location> WAYPOINT_TRANSFORMER = new Function<Waypoint, Location>(){

        public Location apply(@Nullable Waypoint input) {
            return input == null ? null : input.getLocation();
        }
    };

    @Override
    public Editor createEditor(Player player) {
        return new LinearWaypointEditor(player);
    }

    @Override
    public boolean isPaused() {
        return this.currentGoal.isPaused();
    }

    @Override
    public void load(DataKey key) {
        for (DataKey root : key.getRelative("points").getIntegerSubKeys()) {
            if (Bukkit.getWorld((String)(root = root.getRelative("location")).getString("world")) == null) continue;
            this.waypoints.add(new Waypoint(new Location(Bukkit.getWorld((String)root.getString("world")), root.getDouble("x"), root.getDouble("y"), root.getDouble("z"), (float)root.getDouble("yaw", 0.0), (float)root.getDouble("pitch", 0.0))));
        }
    }

    @Override
    public void onSpawn(NPC npc) {
        this.npc = npc;
        if (this.currentGoal == null) {
            this.currentGoal = new LinearWaypointGoal();
            CitizensAPI.registerEvents(this.currentGoal);
            npc.getDefaultGoalController().addGoal(this.currentGoal, 1);
        }
    }

    @Override
    public void save(DataKey key) {
        key.removeKey("points");
        key = key.getRelative("points");
        for (int i = 0; i < this.waypoints.size(); ++i) {
            Location location = this.waypoints.get(i).getLocation();
            DataKey root = key.getRelative(Integer.toString(i) + ".location");
            root.setString("world", location.getWorld().getName());
            root.setDouble("x", location.getX());
            root.setDouble("y", location.getY());
            root.setDouble("z", location.getZ());
            root.setDouble("yaw", location.getYaw());
            root.setDouble("pitch", location.getPitch());
        }
    }

    @Override
    public void setPaused(boolean paused) {
        this.currentGoal.setPaused(paused);
    }

    private class LinearWaypointGoal
    implements Goal {
        private Location currentDestination;
        private Iterator<Location> itr;
        private boolean paused;
        private GoalSelector selector;

        private LinearWaypointGoal() {
        }

        private void ensureItr() {
            if (this.itr == null || !this.itr.hasNext()) {
                this.itr = Iterators.transform(LinearWaypointProvider.this.waypoints.iterator(), (Function)WAYPOINT_TRANSFORMER);
            }
        }

        private Navigator getNavigator() {
            return LinearWaypointProvider.this.npc.getNavigator();
        }

        public boolean isPaused() {
            return this.paused;
        }

        @EventHandler
        public void onNavigationComplete(NavigationCompleteEvent event) {
            if (this.selector == null || !event.getNavigator().equals(this.getNavigator())) {
                return;
            }
            this.selector.finish();
        }

        public void onProviderChanged() {
            this.itr = Iterators.transform(LinearWaypointProvider.this.waypoints.iterator(), (Function)WAYPOINT_TRANSFORMER);
            if (this.currentDestination != null) {
                this.selector.finish();
            }
        }

        @Override
        public void reset() {
            this.currentDestination = null;
            this.selector = null;
        }

        @Override
        public void run(GoalSelector selector) {
            if (!this.getNavigator().isNavigating()) {
                selector.finish();
            }
        }

        public void setPaused(boolean pause) {
            if (pause && this.currentDestination != null) {
                this.selector.finish();
            }
            this.paused = pause;
        }

        @Override
        public boolean shouldExecute(GoalSelector selector) {
            if (this.paused || this.currentDestination != null || !LinearWaypointProvider.this.npc.isSpawned() || this.getNavigator().isNavigating() || LinearWaypointProvider.this.waypoints.size() == 0) {
                return false;
            }
            if (LinearWaypointProvider.this.waypoints.size() == 1) {
                Location dest = LinearWaypointProvider.this.npc.getBukkitEntity().getLocation();
                if (((Waypoint)LinearWaypointProvider.this.waypoints.get(0)).getLocation().distanceSquared(dest) < 3.0) {
                    return false;
                }
            }
            this.ensureItr();
            boolean shouldExecute = this.itr.hasNext();
            if (shouldExecute) {
                this.selector = selector;
                this.currentDestination = this.itr.next();
                this.getNavigator().setTarget(this.currentDestination);
            }
            return shouldExecute;
        }
    }

    private final class LinearWaypointEditor
    extends Editor {
        private final Player player;
        boolean editing = true;
        int editingSlot = LinearWaypointProvider.access$200(LinearWaypointProvider.this).size() - 1;
        private boolean showPath;
        Map<Waypoint, Entity> waypointMarkers = Maps.newHashMap();
        private static final int LARGEST_SLOT = 8;

        private LinearWaypointEditor(Player player) {
            this.player = player;
        }

        @Override
        public void begin() {
            Messaging.send((CommandSender)this.player, ChatColor.AQUA + "Entered the linear waypoint editor!");
            Messaging.send((CommandSender)this.player, "<e>Left click<a> to add a waypoint, <e>right click<a> to remove.");
            Messaging.send((CommandSender)this.player, "<a>Type <e>toggle path<a> to toggle showing entities at waypoints.");
        }

        private void createWaypointMarker(int index, Waypoint waypoint) {
            Entity entity = this.spawnMarker(this.player.getWorld(), waypoint.getLocation().add(0.0, 1.0, 0.0));
            if (entity == null) {
                return;
            }
            entity.setMetadata("waypointindex", (MetadataValue)new FixedMetadataValue(CitizensAPI.getPlugin(), (Object)index));
            this.waypointMarkers.put(waypoint, entity);
        }

        private void createWaypointMarkers() {
            for (int i = 0; i < LinearWaypointProvider.this.waypoints.size(); ++i) {
                this.createWaypointMarker(i, (Waypoint)LinearWaypointProvider.this.waypoints.get(i));
            }
        }

        private void destroyWaypointMarkers() {
            for (Entity entity : this.waypointMarkers.values()) {
                entity.remove();
            }
            this.waypointMarkers.clear();
        }

        @Override
        public void end() {
            if (!this.editing) {
                return;
            }
            Messaging.send((CommandSender)this.player, ChatColor.AQUA + "Exited the linear waypoint editor.");
            this.editing = false;
            if (!this.showPath) {
                return;
            }
            this.destroyWaypointMarkers();
        }

        private String formatLoc(Location location) {
            return String.format("<e>%d<a>, <e>%d<a>, <e>%d<a>", location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }

        private Location getPreviousWaypoint(int fromSlot) {
            if (LinearWaypointProvider.this.waypoints.size() <= 1) {
                return null;
            }
            if (--fromSlot < 0) {
                fromSlot = LinearWaypointProvider.this.waypoints.size() - 1;
            }
            return ((Waypoint)LinearWaypointProvider.this.waypoints.get(fromSlot)).getLocation();
        }

        @EventHandler
        public void onNPCDespawn(NPCDespawnEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler
        public void onNPCRemove(NPCRemoveEvent event) {
            if (event.getNPC().equals(LinearWaypointProvider.this.npc)) {
                Editor.leave(this.player);
            }
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerChat(AsyncPlayerChatEvent event) {
            if (!event.getPlayer().equals(this.player)) {
                return;
            }
            if (!event.getMessage().equalsIgnoreCase("toggle path")) {
                return;
            }
            event.setCancelled(true);
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), new Runnable(){

                @Override
                public void run() {
                    LinearWaypointEditor.this.togglePath();
                }
            }, 1L);
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
            if (!this.player.equals(event.getPlayer()) || !this.showPath) {
                return;
            }
            if (!event.getRightClicked().hasMetadata("waypointindex")) {
                return;
            }
            this.editingSlot = ((MetadataValue)event.getRightClicked().getMetadata("waypointindex").get(0)).asInt();
            Messaging.sendF((CommandSender)this.player, ChatColor.GREEN + "Editing slot set to %s.", StringHelper.wrap(this.editingSlot));
        }

        @EventHandler(ignoreCancelled=true)
        public void onPlayerInteract(PlayerInteractEvent event) {
            if (!event.getPlayer().equals(this.player) || event.getAction() == Action.PHYSICAL) {
                return;
            }
            if (event.getPlayer().getWorld() != LinearWaypointProvider.this.npc.getBukkitEntity().getWorld()) {
                return;
            }
            if (event.getAction() == Action.LEFT_CLICK_BLOCK || event.getAction() == Action.LEFT_CLICK_AIR) {
                double maxDistance;
                double distance;
                if (event.getClickedBlock() == null) {
                    return;
                }
                event.setCancelled(true);
                Location at = event.getClickedBlock().getLocation();
                Location prev = this.getPreviousWaypoint(this.editingSlot);
                if (prev != null && (distance = at.distanceSquared(prev)) > (maxDistance = Math.pow(LinearWaypointProvider.this.npc.getNavigator().getDefaultParameters().range(), 2.0))) {
                    Messaging.sendF((CommandSender)this.player, ChatColor.RED + "Previous waypoint is %s blocks away but the distance limit is %s.", StringHelper.wrap(Math.sqrt(distance), ChatColor.RED), StringHelper.wrap(Math.sqrt(maxDistance), ChatColor.RED));
                    return;
                }
                Waypoint element = new Waypoint(at);
                LinearWaypointProvider.this.waypoints.add(Math.max(0, this.editingSlot), element);
                if (this.showPath) {
                    this.createWaypointMarker(this.editingSlot, element);
                }
                this.editingSlot = Math.min(this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size());
                Messaging.send((CommandSender)this.player, String.format("<e>Added<a> a waypoint at (" + this.formatLoc(at) + ") (<e>%d<a>, <e>%d<a>)", this.editingSlot + 1, LinearWaypointProvider.this.waypoints.size()));
            } else if (LinearWaypointProvider.this.waypoints.size() > 0) {
                event.setCancelled(true);
                this.editingSlot = Math.min(0, Math.max(LinearWaypointProvider.this.waypoints.size() - 1, this.editingSlot));
                Waypoint waypoint = (Waypoint)LinearWaypointProvider.this.waypoints.remove(this.editingSlot);
                if (this.showPath) {
                    this.removeWaypointMarker(waypoint);
                }
                this.editingSlot = Math.max(0, this.editingSlot - 1);
                Messaging.send((CommandSender)this.player, String.format("<e>Removed<a> a waypoint (<e>%d<a> remaining) (<e>%d<a>)", LinearWaypointProvider.this.waypoints.size(), this.editingSlot + 1));
            }
            LinearWaypointProvider.this.currentGoal.onProviderChanged();
        }

        @EventHandler
        public void onPlayerItemHeldChange(PlayerItemHeldEvent event) {
            if (!event.getPlayer().equals(this.player) || LinearWaypointProvider.this.waypoints.size() == 0) {
                return;
            }
            int previousSlot = event.getPreviousSlot();
            int newSlot = event.getNewSlot();
            if (previousSlot == 0 && newSlot == 8) {
                --this.editingSlot;
            } else if (previousSlot == 8 && newSlot == 0) {
                ++this.editingSlot;
            } else {
                int diff = newSlot - previousSlot;
                if (Math.abs(diff) != 1) {
                    return;
                }
                this.editingSlot += diff > 0 ? 1 : -1;
            }
            if (this.editingSlot >= LinearWaypointProvider.this.waypoints.size()) {
                this.editingSlot = 0;
            }
            if (this.editingSlot < 0) {
                this.editingSlot = LinearWaypointProvider.this.waypoints.size() - 1;
            }
            Messaging.send((CommandSender)this.player, "<a>Editing slot set to " + StringHelper.wrap(this.editingSlot) + " (" + this.formatLoc(((Waypoint)LinearWaypointProvider.this.waypoints.get(this.editingSlot)).getLocation()) + ").");
        }

        private void removeWaypointMarker(Waypoint waypoint) {
            Entity entity = this.waypointMarkers.remove(waypoint);
            if (entity != null) {
                entity.remove();
            }
        }

        private Entity spawnMarker(World world, Location at) {
            return NMS.spawnCustomEntity(world, at, EntityEnderCrystalMarker.class, EntityType.ENDER_CRYSTAL);
        }

        private void togglePath() {
            boolean bl = this.showPath = !this.showPath;
            if (this.showPath) {
                this.createWaypointMarkers();
                Messaging.sendF((CommandSender)this.player, "%s waypoint markers.", StringHelper.wrap("Showing"));
            } else {
                this.destroyWaypointMarkers();
                Messaging.sendF((CommandSender)this.player, "%s showing waypoint markers.", StringHelper.wrap("Stopped"));
            }
        }
    }
}

