/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.CommandUsageException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Spellcaster;

@TraitName(value="spellcastertrait")
public class SpellcasterTrait
extends Trait {
    @Persist
    private Spellcaster.Spell spell;

    public SpellcasterTrait() {
        super("spellcastertrait");
    }

    public Spellcaster.Spell getSpell() {
        return this.spell;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !(this.npc.getEntity() instanceof Spellcaster)) {
            return;
        }
        if (this.spell != null) {
            ((Spellcaster)this.npc.getEntity()).setSpell(this.spell);
        }
    }

    public void setSpell(Spellcaster.Spell spell) {
        this.spell = spell;
    }

    @Command(aliases={"npc"}, usage="spellcaster (--spell spell)", desc="", modifiers={"spellcaster"}, min=1, max=1, flags="d", permission="citizens.npc.spellcaster")
    @Requirements(selected=true, ownership=true, types={EntityType.EVOKER, EntityType.ILLUSIONER})
    public static void Spellcaster(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"spell"}) Spellcaster.Spell spell) throws CommandException {
        SpellcasterTrait trait = npc.getOrAddTrait(SpellcasterTrait.class);
        String output = "";
        if (spell != null) {
            trait.setSpell(spell);
            output = output + Messaging.tr("citizens.commands.npc.spellcaster.spell-set", spell);
        }
        if (output.isEmpty()) {
            throw new CommandUsageException();
        }
        Messaging.send(sender, output.trim());
    }
}

