/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.tree.expr;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.tree.expr.Memory;
import net.citizensnpcs.api.npc.NPC;

public class ExpressionScope {
    private final Map<String, Object> cachedValues = new HashMap<String, Object>();
    private final Map<String, Object> eagerValues = new HashMap<String, Object>();
    private final Map<String, Supplier<?>> lazyBindings = new HashMap();
    private Memory memory;
    private NPC npc;
    private final ExpressionScope parent;

    public ExpressionScope() {
        this.parent = null;
    }

    public ExpressionScope(ExpressionScope parent) {
        this.parent = parent;
    }

    public void bind(String name, Supplier<?> supplier) {
        this.lazyBindings.put(name, supplier);
    }

    public ExpressionScope createChild() {
        return new ExpressionScope(this);
    }

    public Object get(String name) {
        Object value = this.eagerValues.get(name);
        if (value != null) {
            return value;
        }
        value = this.cachedValues.get(name);
        if (value != null) {
            return value;
        }
        Supplier<?> supplier = this.lazyBindings.get(name);
        if (supplier != null) {
            value = supplier.get();
            this.cachedValues.put(name, value);
            return value;
        }
        if (this.parent != null) {
            return this.parent.get(name);
        }
        return null;
    }

    public Memory getMemory() {
        if (this.memory != null) {
            return this.memory;
        }
        if (this.parent != null) {
            return this.parent.getMemory();
        }
        return null;
    }

    public NPC getNPC() {
        if (this.npc != null) {
            return this.npc;
        }
        if (this.parent != null) {
            return this.parent.getNPC();
        }
        return null;
    }

    public Iterable<String> getVariableNames() {
        HashSet keys = Sets.newHashSet(this.eagerValues.keySet());
        keys.addAll(this.lazyBindings.keySet());
        return keys;
    }

    public boolean has(String name) {
        if (this.eagerValues.containsKey(name) || this.lazyBindings.containsKey(name)) {
            return true;
        }
        return this.parent != null && this.parent.has(name);
    }

    public void remove(String name) {
        this.eagerValues.remove(name);
        this.lazyBindings.remove(name);
        this.cachedValues.remove(name);
    }

    public void resetCache() {
        this.cachedValues.clear();
    }

    public void set(String name, Object value) {
        this.eagerValues.put(name, value);
    }

    public void setMemory(Memory memory) {
        this.memory = memory;
    }

    public void setNPC(NPC npc) {
        this.npc = npc;
    }
}

