/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.skin;

import com.mojang.authlib.GameProfile;
import java.util.Locale;
import java.util.Set;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.trait.SkinLayers;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.SkinProperty;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.LivingEntity;

public interface SkinnableEntity
extends NPCHolder {
    public void applyTexture(SkinProperty var1);

    public GameProfile gameProfile();

    default public LivingEntity getBukkitEntity() {
        return (LivingEntity)this.getNPC().getEntity();
    }

    default public String getSkinName() {
        String skinName = this.getNPC().getOrAddTrait(SkinTrait.class).getSkinName();
        if (skinName == null) {
            skinName = this.getNPC().getName();
        }
        return skinName.toLowerCase(Locale.ROOT);
    }

    public SkinPacketTracker getSkinTracker();

    public void setSkinFlags(byte var1);

    default public void setSkinFlags(Set<SkinLayers.Layer> flags) {
        this.setSkinFlags(SkinLayers.Layer.toByte(flags));
    }

    default public void setSkinPatch(PlayerSkinModelType type, NamespacedKey body, NamespacedKey cape, NamespacedKey elytra) {
    }

    public static enum PlayerSkinModelType {
        SLIM,
        WIDE;

    }

    public static interface ForwardingSkinnableEntity
    extends SkinnableEntity {
        @Override
        default public void applyTexture(SkinProperty property) {
            this.getUnderlying().applyTexture(property);
        }

        @Override
        default public GameProfile gameProfile() {
            return this.getUnderlying().gameProfile();
        }

        @Override
        default public SkinPacketTracker getSkinTracker() {
            return this.getUnderlying().getSkinTracker();
        }

        public SkinnableEntity getUnderlying();

        @Override
        default public void setSkinFlags(byte flags) {
            this.getUnderlying().setSkinFlags(flags);
        }

        @Override
        default public void setSkinPatch(PlayerSkinModelType type, NamespacedKey body, NamespacedKey cape, NamespacedKey elytra) {
            this.getUnderlying().setSkinPatch(type, body, cape, elytra);
        }
    }
}

