/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import java.util.Objects;
import net.citizensnpcs.api.util.BoundingBox;
import org.bukkit.entity.Entity;

public class EntityDim {
    public final float height;
    public final float width;

    public EntityDim(double width, double height) {
        this((float)width, (float)height);
    }

    public EntityDim(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public EntityDim clone() {
        return new EntityDim(this.width, this.height);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EntityDim other = (EntityDim)obj;
        return Double.doubleToLongBits(this.height) == Double.doubleToLongBits(other.height) && Double.doubleToLongBits(this.width) == Double.doubleToLongBits(other.width);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.height), Float.valueOf(this.width));
    }

    public EntityDim mul(float scale) {
        return new EntityDim(this.width * scale, this.height * scale);
    }

    public String toString() {
        return "EntityDim [height=" + this.height + ", width=" + this.width + "]";
    }

    public static EntityDim from(BoundingBox bb) {
        return new EntityDim(bb.maxX - bb.minX, bb.maxY - bb.minY);
    }

    public static EntityDim from(Entity entity) {
        return new EntityDim(entity.getWidth(), entity.getHeight());
    }
}

