/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Translator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Messaging {
    private static final Pattern CHAT_NEWLINE = Pattern.compile("<br>|<n>|\\n", 8);
    private static final Splitter CHAT_NEWLINE_SPLITTER = Splitter.on((Pattern)CHAT_NEWLINE);
    private static final Joiner SPACE = Joiner.on((String)" ").useForNull("null");

    public static void debug(Object ... msg) {
        if (Settings.Setting.DEBUG_MODE.asBoolean()) {
            Messaging.log(msg);
        }
    }

    public static void log(Level level, Object ... msg) {
        Bukkit.getLogger().log(level, "[Citizens] " + SPACE.join(msg));
    }

    public static void log(Object ... msg) {
        Messaging.log(Level.INFO, msg);
    }

    public static void logTr(String key, Object ... msg) {
        Messaging.log(Level.INFO, Translator.translate(key, msg));
    }

    public static void send(CommandSender sender, Object ... msg) {
        Messaging.sendMessageTo(sender, SPACE.join(msg));
    }

    public static void sendError(CommandSender sender, Object ... msg) {
        Messaging.send(sender, ChatColor.RED.toString() + SPACE.join(msg));
    }

    public static void sendErrorTr(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, ChatColor.RED + Translator.translate(key, msg));
    }

    private static void sendMessageTo(CommandSender sender, String rawMessage) {
        rawMessage = StringHelper.parseColors(rawMessage);
        for (String message : CHAT_NEWLINE_SPLITTER.split((CharSequence)rawMessage)) {
            String trimmed = message.trim();
            String messageColour = StringHelper.parseColors(Settings.Setting.MESSAGE_COLOUR.asString());
            if (!trimmed.isEmpty()) {
                if (trimmed.charAt(0) != '\u00a7') {
                    message = StringHelper.parseColors(Settings.Setting.MESSAGE_COLOUR.asString()) + message;
                } else {
                    messageColour = ChatColor.getByChar((String)message.substring(1, 2)).toString();
                }
            }
            message = message.replace("[[", StringHelper.parseColors(Settings.Setting.HIGHLIGHT_COLOUR.asString()));
            message = message.replace("]]", messageColour);
            sender.sendMessage(message);
        }
    }

    public static void sendTr(CommandSender sender, String key, Object ... msg) {
        Messaging.sendMessageTo(sender, Translator.translate(key, msg));
    }

    public static void sendWithNPC(CommandSender sender, Object msg, NPC npc) {
        String send = msg.toString();
        if (sender instanceof Player) {
            Player player = (Player)sender;
            send = send.replace("<player>", player.getName());
            send = send.replace("<world>", player.getWorld().getName());
        }
        send = send.replace("<owner>", npc.getTrait(Owner.class).getOwner());
        send = send.replace("<npc>", npc.getName());
        send = send.replace("<id>", Integer.toString(npc.getId()));
        Messaging.send(sender, send);
    }

    public static void severe(Object ... messages) {
        Messaging.log(Level.SEVERE, messages);
    }

    public static void severeTr(String key, Object ... messages) {
        Messaging.log(Level.SEVERE, Translator.translate(key, messages));
    }

    public static String tr(String key, Object ... messages) {
        return Translator.translate(key, messages);
    }

    public static String tryTranslate(Object possible) {
        if (possible == null) {
            return "";
        }
        String message = possible.toString();
        int count = 0;
        for (int i = 0; i < message.length(); ++i) {
            char c = message.charAt(i);
            if (c != '.') continue;
            ++count;
        }
        return count >= 2 ? Messaging.tr(message, new Object[0]) : message;
    }
}

