/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;

public class RhinoScriptEngine
extends AbstractScriptEngine
implements Invocable,
Compilable {
    private ScriptEngineFactory factory;

    @Override
    public CompiledScript compile(Reader from) throws ScriptException {
        Context cx = Context.enter();
        cx.initStandardObjects();
        String filename = (String)this.get("javax.script.filename");
        filename = filename == null ? "<unknown>" : filename;
        try {
            Script compiled = cx.compileReader(from, filename, 0, null);
            RhinoCompiledScript rhinoCompiledScript = new RhinoCompiledScript(this, compiled);
            return rhinoCompiledScript;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return this.compile(new StringReader(script));
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        Context cx = Context.enter();
        Scriptable scope = cx.initStandardObjects((ScriptableObject)new ImporterTopLevel(cx));
        String filename = (String)this.get("javax.script.filename");
        filename = filename == null ? "<unknown>" : filename;
        for (Map.Entry entry : context.getBindings(100).entrySet()) {
            ScriptableObject.putProperty((Scriptable)scope, (String)((String)entry.getKey()), (Object)Context.javaToJS(entry.getValue(), (Scriptable)scope));
        }
        try {
            Object i$ = cx.evaluateReader(scope, reader, filename, 0, (Object)filename);
            return i$;
        }
        catch (Error e) {
            throw new ScriptException(e.getMessage());
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
        catch (RhinoException e) {
            String msg = e instanceof JavaScriptException ? ((JavaScriptException)e).getValue().toString() : e.getMessage();
            int lineNumber = e.lineNumber() == 0 ? -1 : e.lineNumber();
            ScriptException scriptException = new ScriptException(msg, e.sourceName(), lineNumber);
            scriptException.initCause(e);
            throw scriptException;
        }
        finally {
            Context.exit();
        }
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval((Reader)new StringReader(script), context);
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        try {
            return clazz.cast(Context.jsToJava(null, clazz));
        }
        catch (EvaluatorException ex) {
            return null;
        }
    }

    @Override
    public <T> T getInterface(Object thiz, Class<T> clazz) {
        try {
            return clazz.cast(Context.jsToJava((Object)thiz, clazz));
        }
        catch (EvaluatorException ex) {
            return null;
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return null;
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        return null;
    }

    public ScriptEngine setScriptEngineFactory(ScriptEngineFactory factory) {
        this.factory = factory;
        return this;
    }

    private static Object unwrapReturnValue(Object obj) {
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        return obj instanceof Undefined ? null : obj;
    }

    public static class RhinoCompiledScript
    extends CompiledScript {
        private final ScriptEngine engine;
        private final Script script;

        RhinoCompiledScript(ScriptEngine engine, Script script) {
            this.engine = engine;
            this.script = script;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object eval(ScriptContext context) throws ScriptException {
            Context cx = Context.enter();
            try {
                Object object = RhinoScriptEngine.unwrapReturnValue(this.script.exec(cx, (Scriptable)cx.initStandardObjects()));
                return object;
            }
            catch (Exception exception) {
            }
            finally {
                Context.exit();
            }
            return null;
        }

        @Override
        public ScriptEngine getEngine() {
            return this.engine;
        }
    }
}

