/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.util.Map;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.util.NMS;
import net.minecraft.server.Block;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.World;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.craftbukkit.CraftWorld;

public abstract class CitizensMobNPC
extends CitizensNPC {
    private final Constructor<? extends EntityLiving> constructor;
    private static final Map<Class<? extends EntityLiving>, Constructor<? extends EntityLiving>> CONSTRUCTOR_CACHE = Maps.newHashMap();

    protected CitizensMobNPC(int id, String name, Class<? extends EntityLiving> clazz) {
        super(id, name);
        this.constructor = CitizensMobNPC.getConstructor(clazz);
        NMS.registerEntityClass(clazz);
    }

    private EntityLiving createEntityFromClass(World world) {
        try {
            return this.constructor.newInstance(world, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    protected EntityLiving createHandle(Location loc) {
        Block block;
        EntityLiving entity = this.createEntityFromClass((World)((CraftWorld)loc.getWorld()).getHandle());
        entity.setPositionRotation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        Material beneath = loc.getBlock().getRelative(BlockFace.DOWN).getType();
        if (beneath.isBlock() && (block = Block.byId[beneath.getId()]) != null && block.material != null) {
            entity.onGround = block.material.isSolid();
        }
        return entity;
    }

    private static Constructor<? extends EntityLiving> getConstructor(Class<? extends EntityLiving> clazz) {
        Constructor<? extends EntityLiving> constructor = CONSTRUCTOR_CACHE.get(clazz);
        if (constructor != null) {
            return constructor;
        }
        try {
            return clazz.getConstructor(World.class, NPC.class);
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to find an entity constructor");
        }
    }
}

