/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.persistence;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.citizensnpcs.api.persistence.DelegatePersistence;
import net.citizensnpcs.api.persistence.LocationPersister;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Location;

public class PersistenceLoader {
    private static final Map<Class<?>, Field[]> fieldCache = new WeakHashMap();
    private static final Map<Class<? extends Persister>, Persister> loadedDelegates = new WeakHashMap<Class<? extends Persister>, Persister>();
    private static final Exception loadException = new Exception(){
        private static final long serialVersionUID = -4245839150826112365L;

        public void fillInStackTrace(StackTraceElement[] elements) {
        }
    };
    private static final Map<Class<?>, Class<? extends Persister>> persistRedirects = new WeakHashMap();

    private static String createRelativeKey(String key, int ext) {
        return PersistenceLoader.createRelativeKey(key, Integer.toString(ext));
    }

    private static String createRelativeKey(String parent, String ext) {
        if (ext.isEmpty()) {
            return parent;
        }
        if (ext.charAt(0) == '.') {
            return parent.isEmpty() ? ext.substring(1, ext.length()) : parent + ext;
        }
        return parent.isEmpty() ? ext : parent + '.' + ext;
    }

    private static void deserialise(PersistField field, DataKey root) throws Exception {
        Object value;
        Class<?> type = field.getType();
        Class<Collection<?>> collectionType = field.getCollectionType();
        if (List.class.isAssignableFrom(type)) {
            List list = (List)(!List.class.isAssignableFrom(collectionType) ? Lists.newArrayList() : collectionType.newInstance());
            Object raw = root.getRaw(field.key);
            if (raw instanceof List && collectionType.isAssignableFrom(raw.getClass())) {
                list = (List)raw;
            } else {
                for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
                    Object loaded = PersistenceLoader.getValueFromKey(field, subKey);
                    if (loaded == null) continue;
                    list.add(loaded);
                }
            }
            value = list;
        } else if (Set.class.isAssignableFrom(type)) {
            Set set = (Set)(!Set.class.isAssignableFrom(collectionType) ? Sets.newHashSet() : collectionType.newInstance());
            Object raw = root.getRaw(field.key);
            if (raw instanceof Set && collectionType.isAssignableFrom(raw.getClass())) {
                set = (Set)raw;
            } else {
                for (DataKey subKey : root.getRelative(field.key).getSubKeys()) {
                    Object loaded = PersistenceLoader.getValueFromKey(field, subKey);
                    if (loaded == null) continue;
                    set.add(loaded);
                }
            }
            value = set;
        } else {
            value = PersistenceLoader.getValueFromKey(field, root);
        }
        if (value == null && field.isRequired()) {
            throw loadException;
        }
        if (!type.isAssignableFrom(value.getClass())) {
            return;
        }
        field.set(value);
    }

    private static void ensureDelegateLoaded(Class<? extends Persister> delegateClass) {
        if (loadedDelegates.containsKey(delegateClass)) {
            return;
        }
        try {
            loadedDelegates.put(delegateClass, delegateClass.newInstance());
        }
        catch (Exception e) {
            e.printStackTrace();
            loadedDelegates.put(delegateClass, null);
        }
    }

    private static Persister getDelegate(Field field, Class<?> fallback) {
        Persister persister;
        DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
        if (delegate == null) {
            persister = loadedDelegates.get(persistRedirects.get(fallback));
            if (persister == null) {
                return null;
            }
        } else {
            persister = loadedDelegates.get(delegate.value());
        }
        if (persister == null) {
            persister = loadedDelegates.get(persistRedirects.get(fallback));
        }
        return persister;
    }

    private static Field[] getFields(Class<?> clazz) {
        Field[] fields = fieldCache.get(clazz);
        if (fields == null) {
            fields = PersistenceLoader.getFieldsFromClass(clazz);
            fieldCache.put(clazz, fields);
        }
        return fields;
    }

    private static Field[] getFieldsFromClass(Class<?> clazz) {
        ArrayList toFilter = Lists.newArrayList((Object[])clazz.getDeclaredFields());
        Iterator itr = toFilter.iterator();
        while (itr.hasNext()) {
            Field field = (Field)itr.next();
            field.setAccessible(true);
            Persist persistAnnotation = field.getAnnotation(Persist.class);
            if (persistAnnotation == null) {
                itr.remove();
                continue;
            }
            DelegatePersistence delegate = field.getAnnotation(DelegatePersistence.class);
            if (delegate == null) continue;
            Class<? extends Persister> delegateClass = delegate.value();
            PersistenceLoader.ensureDelegateLoaded(delegateClass);
            Persister in = loadedDelegates.get(delegateClass);
            if (in != null) continue;
            itr.remove();
        }
        return toFilter.toArray(new Field[toFilter.size()]);
    }

    private static Object getValueFromKey(PersistField field, DataKey root) {
        return field.delegate == null ? root.getRaw(field.key) : field.delegate.create(root.getRelative(field.key));
    }

    public static <T> T load(Class<? extends T> clazz, DataKey root) {
        try {
            return PersistenceLoader.load(clazz.newInstance(), root);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T load(T instance, DataKey root) {
        Field[] fields;
        Class<?> clazz = instance.getClass();
        for (Field field : fields = PersistenceLoader.getFields(clazz)) {
            try {
                PersistenceLoader.deserialise(new PersistField(field, instance), root);
            }
            catch (Exception e) {
                if (e == loadException) {
                    return null;
                }
                e.printStackTrace();
            }
        }
        return instance;
    }

    public static void registerPersistDelegate(Class<?> clazz, Class<? extends Persister> delegateClass) {
        persistRedirects.put(clazz, delegateClass);
        PersistenceLoader.ensureDelegateLoaded(delegateClass);
    }

    public static void save(Object instance, DataKey root) {
        Field[] fields;
        Class<?> clazz = instance.getClass();
        for (Field field : fields = PersistenceLoader.getFields(clazz)) {
            PersistenceLoader.serialise(new PersistField(field, instance), root);
        }
    }

    private static void serialise(PersistField field, DataKey root) {
        if (field.get() == null) {
            return;
        }
        if (List.class.isAssignableFrom(field.getType())) {
            List list = (List)field.get();
            root.removeKey(field.key);
            for (int i = 0; i < list.size(); ++i) {
                String key = PersistenceLoader.createRelativeKey(field.key, i);
                if (field.delegate != null) {
                    field.delegate.save(list.get(i), root.getRelative(key));
                    continue;
                }
                root.setRaw(key, list.get(i));
            }
        } else if (field.delegate != null) {
            field.delegate.save(field.get(), root.getRelative(field.key));
        } else {
            root.setRaw(field.key, field.get());
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(Location.class, LocationPersister.class);
    }

    private static class PersistField {
        private final Persister delegate;
        private final Field field;
        private final Object instance;
        private final String key;
        private final Persist persistAnnotation;
        private Object value;
        private static final Object NULL = new Object();

        private PersistField(Field field, Object instance) {
            this.field = field;
            this.persistAnnotation = field.getAnnotation(Persist.class);
            this.key = this.persistAnnotation.value().equals("UNINITIALISED") ? field.getName() : this.persistAnnotation.value();
            Class fallback = field.getType();
            if (field.getGenericType() instanceof ParameterizedType) {
                fallback = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0];
            }
            this.delegate = PersistenceLoader.getDelegate(field, fallback);
            this.instance = instance;
        }

        public <T> T get() {
            if (this.value == null) {
                try {
                    this.value = this.field.get(this.instance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.value = NULL;
                }
            }
            if (this.value == NULL) {
                return null;
            }
            return (T)this.value;
        }

        public Class<? super Collection<?>> getCollectionType() {
            return this.persistAnnotation.collectionType();
        }

        public Class<?> getType() {
            return this.field.getType();
        }

        public boolean isRequired() {
            return this.persistAnnotation.required();
        }

        public void set(Object value) {
            try {
                this.field.set(this.instance, value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

