/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTrigger;
import net.citizensnpcs.trait.waypoint.triggers.WaypointTriggerRegistry;
import org.bukkit.Location;

public class Waypoint {
    @Persist(required=true)
    private Location location;
    @Persist
    private List<WaypointTrigger> triggers;

    public Waypoint() {
    }

    public Waypoint(Location at) {
        this.location = at;
    }

    public void addTrigger(WaypointTrigger trigger) {
        if (this.triggers == null) {
            this.triggers = Lists.newArrayList();
        }
        this.triggers.add(trigger);
    }

    public Location getLocation() {
        return this.location;
    }

    public List<WaypointTrigger> getTriggers() {
        return this.triggers == null ? Collections.EMPTY_LIST : this.triggers;
    }

    public void onReach(NPC npc) {
        if (this.triggers == null) {
            return;
        }
        for (WaypointTrigger trigger : this.triggers) {
            trigger.onWaypointReached(npc, this.location);
        }
    }

    static {
        PersistenceLoader.registerPersistDelegate(WaypointTrigger.class, WaypointTriggerRegistry.class);
    }
}

