/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Sets;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

@TraitName(value="playerfilter")
public class PlayerFilter
extends Trait {
    @Persist
    private Set<UUID> allowlist = null;
    @Persist
    private Set<String> groupAllowlist = null;
    @Persist
    private Set<String> groupHidden = null;
    @Persist
    private Set<UUID> hidden = null;
    private Function<Player, Boolean> hideFunction = p -> {
        if (this.allowlist != null && !this.allowlist.contains(p.getUniqueId())) {
            return true;
        }
        if (this.hidden != null && this.hidden.contains(p.getUniqueId())) {
            return true;
        }
        if (this.groupAllowlist != null || this.groupHidden != null) {
            RegisteredServiceProvider groups = Bukkit.getServicesManager().getRegistration(Permission.class);
            if (groups != null && !this.groupAllowlist.stream().anyMatch(group -> ((Permission)groups.getProvider()).playerInGroup(p, group))) {
                return true;
            }
            if (groups != null && this.groupHidden.stream().anyMatch(group -> ((Permission)groups.getProvider()).playerInGroup(p, group))) {
                return true;
            }
        }
        return false;
    };

    public PlayerFilter() {
        super("playerfilter");
    }

    public void clear() {
        this.allowlist = null;
        this.hidden = null;
        this.groupHidden = null;
        this.groupAllowlist = null;
    }

    public void hide(UUID uuid) {
        if (this.hidden == null) {
            this.hidden = Sets.newHashSet();
        }
        this.hidden.add(uuid);
    }

    public void hideGroup(String group) {
        if (this.groupHidden == null) {
            this.groupHidden = Sets.newHashSet();
        }
        this.groupHidden.add(group);
    }

    public boolean isHidden(Player player) {
        if (this.hideFunction == null) {
            return false;
        }
        return this.hideFunction.apply(player);
    }

    public void only(UUID uuid) {
        if (this.allowlist == null) {
            this.allowlist = Sets.newHashSet();
        }
        this.allowlist.add(uuid);
    }

    public void onlyGroup(String group) {
        if (this.groupAllowlist == null) {
            this.groupAllowlist = Sets.newHashSet();
        }
        this.groupAllowlist.add(group);
    }

    public void setPlayerFilter(Function<Player, Boolean> filter) {
        this.hideFunction = filter;
    }

    public void unhide(UUID uuid) {
        if (this.hidden != null) {
            this.hidden.remove(uuid);
        }
        if (this.hidden.size() == 0) {
            this.hidden = null;
        }
        if (this.allowlist != null) {
            this.allowlist.remove(uuid);
        }
    }

    public void unhideGroup(String group) {
        if (this.groupHidden != null) {
            this.groupHidden.remove(group);
        }
        if (this.groupHidden.size() == 0) {
            this.groupHidden = null;
        }
        if (this.groupAllowlist != null) {
            this.groupAllowlist = null;
        }
    }
}

