/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import java.util.UUID;
import java.util.function.Supplier;
import net.citizensnpcs.api.ai.GoalController;
import net.citizensnpcs.api.ai.Navigator;
import net.citizensnpcs.api.ai.speech.SpeechController;
import net.citizensnpcs.api.astar.Agent;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.event.SpawnReason;
import net.citizensnpcs.api.npc.BlockBreaker;
import net.citizensnpcs.api.npc.MetadataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;

public interface NPC
extends Agent,
Cloneable {
    public void addRunnable(Runnable var1);

    public void addTrait(Class<? extends Trait> var1);

    public void addTrait(Trait var1);

    public NPC clone();

    public NPC copy();

    public MetadataStore data();

    public boolean despawn();

    public boolean despawn(DespawnReason var1);

    public void destroy();

    public void destroy(CommandSender var1);

    public void faceLocation(Location var1);

    public BlockBreaker getBlockBreaker(Block var1, BlockBreaker.BlockBreakerConfiguration var2);

    public GoalController getDefaultGoalController();

    public SpeechController getDefaultSpeechController();

    public Entity getEntity();

    public String getFullName();

    public int getId();

    public Supplier<ItemStack> getItemProvider();

    public String getName();

    public Navigator getNavigator();

    public <T extends Trait> T getOrAddTrait(Class<T> var1);

    public NPCRegistry getOwningRegistry();

    public String getRawName();

    public Location getStoredLocation();

    @Deprecated
    public <T extends Trait> T getTrait(Class<T> var1);

    public <T extends Trait> T getTraitNullable(Class<T> var1);

    public Iterable<Trait> getTraits();

    public UUID getUniqueId();

    public boolean hasTrait(Class<? extends Trait> var1);

    public boolean isFlyable();

    public boolean isHiddenFrom(Player var1);

    public boolean isProtected();

    public boolean isPushableByFluids();

    public boolean isSpawned();

    public boolean isUpdating(NPCUpdate var1);

    public void load(DataKey var1);

    public void removeTrait(Class<? extends Trait> var1);

    public boolean requiresNameHologram();

    public void save(DataKey var1);

    public void scheduleUpdate(NPCUpdate var1);

    public void setAlwaysUseNameHologram(boolean var1);

    public void setBukkitEntityType(EntityType var1);

    public void setFlyable(boolean var1);

    public void setItemProvider(Supplier<ItemStack> var1);

    public void setMoveDestination(Location var1);

    public void setName(String var1);

    public void setProtected(boolean var1);

    public void setUseMinecraftAI(boolean var1);

    public boolean spawn(Location var1);

    public boolean spawn(Location var1, SpawnReason var2);

    public void teleport(Location var1, PlayerTeleportEvent.TeleportCause var2);

    public void updateCustomName();

    public boolean useMinecraftAI();

    public static enum NPCUpdate {
        PACKET;

    }

    public static enum Metadata {
        ACTIVATION_RANGE("activation-range"),
        AGGRESSIVE("entity-aggressive"),
        ALWAYS_USE_NAME_HOLOGRAM("always-use-name-hologram"),
        AMBIENT_SOUND("ambient-sound"),
        BOUNDING_BOX_FUNCTION("bounding-box-function"),
        COLLIDABLE("collidable"),
        DAMAGE_OTHERS("damage-others"),
        DEATH_SOUND("death-sound"),
        DEFAULT_PROTECTED("protected"),
        DISABLE_DEFAULT_STUCK_ACTION("disable-default-stuck-action"),
        DROPS_ITEMS("drops-items"),
        FLUID_PUSHABLE("fluid-pushable"),
        FLYABLE("flyable"),
        FORCE_PACKET_UPDATE("force-packet-update"),
        GLOWING("glowing"),
        HURT_SOUND("hurt-sound"),
        ITEM_AMOUNT("item-type-amount"),
        ITEM_DATA("item-type-data"),
        ITEM_ID("item-type-id"),
        KEEP_CHUNK_LOADED("keep-chunk-loaded"),
        LEASH_PROTECTED("protected-leash"),
        MINECART_ITEM("minecart-item-name"),
        MINECART_ITEM_DATA("minecart-item-data"),
        MINECART_OFFSET("minecart-item-offset"),
        NAMEPLATE_VISIBLE("nameplate-visible"),
        PACKET_UPDATE_DELAY("packet-update-delay"),
        PATHFINDER_FALL_DISTANCE("pathfinder-fall-distance"),
        PATHFINDER_OPEN_DOORS("pathfinder-open-doors"),
        PICKUP_ITEMS("pickup-items"),
        PLAYER_SKIN_TEXTURE_PROPERTIES("player-skin-textures"),
        PLAYER_SKIN_TEXTURE_PROPERTIES_SIGN("player-skin-signature"),
        PLAYER_SKIN_USE_LATEST("player-skin-use-latest-skin"),
        PLAYER_SKIN_UUID("player-skin-name"),
        REMOVE_FROM_PLAYERLIST("removefromplayerlist"),
        RESET_PITCH_ON_TICK("reset-pitch-on-tick"),
        RESPAWN_DELAY("respawn-delay"),
        SCOREBOARD_FAKE_TEAM_NAME("fake-scoreboard-team-name"),
        SHOULD_SAVE("should-save"),
        SILENT("silent-sounds"),
        SNEAKING("citizens-sneaking"),
        SPAWN_NODAMAGE_TICKS("spawn-nodamage-ticks"),
        SWIMMING("swim"),
        TARGETABLE("protected-target"),
        TRACKING_RANGE("tracking-distance"),
        USE_MINECRAFT_AI("minecraft-ai"),
        USING_HELD_ITEM("using-held-item"),
        USING_OFFHAND_ITEM("using-offhand-item"),
        VILLAGER_BLOCK_TRADES("villager-trades"),
        WATER_SPEED_MODIFIER("water-speed-modifier");

        private final String key;

        private Metadata(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public static Metadata byKey(String name) {
            for (Metadata v : Metadata.values()) {
                if (!v.key.equals(name)) continue;
                return v;
            }
            return null;
        }

        public static Metadata byName(String name) {
            try {
                return Metadata.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                return null;
            }
        }
    }
}

