/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.flocking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.npc.NPC;

public class GroupNPCFlock
implements NPCFlock {
    private final List<NPC> npcs = new ArrayList<NPC>();
    private final double radius;

    public GroupNPCFlock(Iterable<NPC> npcs, double radius) {
        this.radius = radius;
    }

    @Override
    public Collection<NPC> getNearby(final NPC npc) {
        if (this.radius < 0.0) {
            return this.npcs;
        }
        return this.npcs.stream().filter(new Predicate<NPC>(){

            @Override
            public boolean test(NPC input) {
                return input.getStoredLocation().distance(npc.getStoredLocation()) < GroupNPCFlock.this.radius;
            }
        }).collect(Collectors.toList());
    }

    public List<NPC> getNPCs() {
        return this.npcs;
    }

    public static GroupNPCFlock create(Iterable<NPC> npcs) {
        return new GroupNPCFlock(npcs, -1.0);
    }

    public static GroupNPCFlock createWithRadius(Iterable<NPC> npcs, double radius) {
        return new GroupNPCFlock(npcs, radius);
    }
}

