/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.ai.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.citizensnpcs.api.ai.event.CancelReason;
import net.citizensnpcs.api.ai.event.NavigatorCallback;
import net.citizensnpcs.api.ai.tree.BehaviorGoalAdapter;
import net.citizensnpcs.api.ai.tree.BehaviorStatus;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class TargetNearbyEntityGoal
extends BehaviorGoalAdapter {
    private final boolean aggressive;
    private boolean finished;
    private final NPC npc;
    private final double radius;
    private CancelReason reason;
    private Entity target;
    private final Set<EntityType> targets;

    private TargetNearbyEntityGoal(NPC npc, Set<EntityType> targets, boolean aggressive, double radius) {
        this.npc = npc;
        this.targets = targets;
        this.aggressive = aggressive;
        this.radius = radius;
    }

    @Override
    public void reset() {
        this.npc.getNavigator().cancelNavigation();
        this.target = null;
        this.finished = false;
        this.reason = null;
    }

    @Override
    public BehaviorStatus run() {
        if (this.finished) {
            return this.reason == null ? BehaviorStatus.SUCCESS : BehaviorStatus.FAILURE;
        }
        return BehaviorStatus.RUNNING;
    }

    @Override
    public boolean shouldExecute() {
        if (this.targets.size() == 0 || !this.npc.isSpawned()) {
            return false;
        }
        List nearby = this.npc.getEntity().getNearbyEntities(this.radius, this.radius, this.radius);
        this.target = null;
        for (Entity entity : nearby) {
            if (!this.targets.contains(entity.getType())) continue;
            this.target = entity;
            break;
        }
        if (this.target != null) {
            this.npc.getNavigator().setTarget(this.target, this.aggressive);
            this.npc.getNavigator().getLocalParameters().addSingleUseCallback(new NavigatorCallback(){

                @Override
                public void onCompletion(CancelReason cancelReason) {
                    TargetNearbyEntityGoal.this.reason = cancelReason;
                    TargetNearbyEntityGoal.this.finished = true;
                }
            });
            return true;
        }
        return false;
    }

    public static Builder builder(NPC npc) {
        return new Builder(npc);
    }

    public static class Builder {
        private boolean aggressive;
        private final NPC npc;
        private double radius = 10.0;
        private Set<EntityType> targetTypes = EnumSet.noneOf(EntityType.class);

        public Builder(NPC npc) {
            this.npc = npc;
        }

        public Builder aggressive(boolean aggressive) {
            this.aggressive = aggressive;
            return this;
        }

        public TargetNearbyEntityGoal build() {
            return new TargetNearbyEntityGoal(this.npc, this.targetTypes, this.aggressive, this.radius);
        }

        public Builder radius(double radius) {
            this.radius = radius;
            return this;
        }

        public Builder targets(Set<EntityType> targetTypes) {
            this.targetTypes = targetTypes;
            return this;
        }
    }
}

