/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.astar.Plan;

public abstract class AStarNode
implements Comparable<AStarNode> {
    float g;
    float h;
    AStarNode parent;
    List<AStarNode> parents;

    protected AStarNode(AStarNode parent) {
        this.parent = parent;
    }

    public abstract Plan buildPlan();

    @Override
    public int compareTo(AStarNode other) {
        return Float.compare(this.g + this.h, other.g + other.h);
    }

    public abstract boolean equals(Object var1);

    public abstract Iterable<AStarNode> getNeighbours();

    protected AStarNode getParent() {
        return this.parent;
    }

    protected <T extends AStarNode> Iterable<T> getParents() {
        if (this.parents != null) {
            return this.parents;
        }
        this.parents = Lists.newArrayList();
        AStarNode start = this;
        while (start != null) {
            this.parents.add(start);
            start = start.parent;
        }
        Collections.reverse(this.parents);
        return this.parents;
    }

    protected float getPathCost() {
        return this.g + this.h;
    }

    public abstract int hashCode();
}

