/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.astar;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.AStarStorage;

public class SimpleAStarStorage
implements AStarStorage {
    private final Map<AStarNode, Float> closed = Maps.newHashMapWithExpectedSize((int)512);
    private final Map<AStarNode, Float> open = Maps.newHashMapWithExpectedSize((int)128);
    private final Queue<AStarNode> queue = new PriorityQueue<AStarNode>(128);
    public static final Supplier<AStarStorage> FACTORY = new Supplier<AStarStorage>(){

        public AStarStorage get() {
            return new SimpleAStarStorage();
        }
    };

    @Override
    public void close(AStarNode node) {
        this.open.remove(node);
        this.closed.put(node, Float.valueOf(node.g));
    }

    @Override
    public AStarNode getBestNode() {
        return this.queue.peek();
    }

    @Override
    public void open(AStarNode node) {
        this.queue.offer(node);
        this.open.put(node, Float.valueOf(node.g));
        this.closed.remove(node);
    }

    @Override
    public AStarNode removeBestNode() {
        return this.queue.poll();
    }

    @Override
    public boolean shouldExamine(AStarNode neighbour) {
        Float closedG;
        Float openG = this.open.get(neighbour);
        if (openG != null && openG.floatValue() > neighbour.g) {
            this.open.remove(neighbour);
            openG = null;
        }
        if ((closedG = this.closed.get(neighbour)) != null && closedG.floatValue() > neighbour.g) {
            this.closed.remove(neighbour);
            closedG = null;
        }
        return closedG == null && openG == null;
    }

    public String toString() {
        return "SimpleAStarStorage [closed=" + this.closed + ", open=" + this.open + "]";
    }
}

