/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

@TraitName(value="playerfilter")
public class PlayerFilter
extends Trait {
    @Persist
    private Set<UUID> allowlist = null;
    private Function<Player, Boolean> filter;
    @Persist
    private Set<String> groupAllowlist = null;
    @Persist
    private Set<String> groupHidden = null;
    @Persist
    private Set<UUID> hidden = null;
    private final Set<UUID> hiddenPlayers = Sets.newHashSet();
    private BiConsumer<Player, Entity> hideFunction;
    private BiConsumer<Player, Entity> viewFunction;
    private final Set<UUID> viewingPlayers = Sets.newHashSet();

    public PlayerFilter() {
        super("playerfilter");
    }

    public PlayerFilter(BiConsumer<Player, Entity> hideFunction, BiConsumer<Player, Entity> viewFunction) {
        this();
        this.filter = p -> {
            if (this.allowlist != null && !this.allowlist.contains(p.getUniqueId())) {
                return true;
            }
            if (this.hidden != null && this.hidden.contains(p.getUniqueId())) {
                return true;
            }
            if (this.groupAllowlist != null || this.groupHidden != null) {
                RegisteredServiceProvider groups = Bukkit.getServicesManager().getRegistration(Permission.class);
                if (groups != null && !this.groupAllowlist.stream().anyMatch(group -> ((Permission)groups.getProvider()).playerInGroup(p, group))) {
                    return true;
                }
                if (groups != null && this.groupHidden.stream().anyMatch(group -> ((Permission)groups.getProvider()).playerInGroup(p, group))) {
                    return true;
                }
            }
            return false;
        };
        this.hideFunction = hideFunction;
        this.viewFunction = viewFunction;
    }

    public void clear() {
        this.allowlist = null;
        this.hidden = null;
        this.groupHidden = null;
        this.groupAllowlist = null;
    }

    public void hide(UUID uuid) {
        if (this.hidden == null) {
            this.hidden = Sets.newHashSet();
        }
        this.hidden.add(uuid);
        this.viewingPlayers.add(uuid);
        this.recalculate();
    }

    public void hideGroup(String group) {
        if (this.groupHidden == null) {
            this.groupHidden = Sets.newHashSet();
        }
        this.groupHidden.add(group);
        this.recalculate();
    }

    public boolean isHidden(Player player) {
        return this.filter == null ? false : this.filter.apply(player);
    }

    @Override
    public void onDespawn() {
        this.hiddenPlayers.clear();
        this.viewingPlayers.clear();
    }

    public void only(UUID uuid) {
        if (this.allowlist == null) {
            this.allowlist = Sets.newHashSet();
        }
        this.allowlist.add(uuid);
        this.recalculate();
    }

    public void onlyGroup(String group) {
        if (this.groupAllowlist == null) {
            this.groupAllowlist = Sets.newHashSet();
        }
        this.groupAllowlist.add(group);
        this.recalculate();
    }

    public boolean onSeenByPlayer(Player player) {
        if (this.isHidden(player)) {
            this.hiddenPlayers.add(player.getUniqueId());
            return true;
        }
        this.viewingPlayers.add(player.getUniqueId());
        return false;
    }

    public void recalculate() {
        Player player;
        UUID uuid;
        Iterator<UUID> itr = this.viewingPlayers.iterator();
        while (itr.hasNext()) {
            uuid = itr.next();
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                itr.remove();
                continue;
            }
            if (this.hideFunction == null || !this.filter.apply(player).booleanValue()) continue;
            this.hideFunction.accept(player, this.npc.getEntity());
            itr.remove();
        }
        itr = this.hiddenPlayers.iterator();
        while (itr.hasNext()) {
            uuid = itr.next();
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                itr.remove();
                continue;
            }
            if (this.viewFunction == null || this.filter.apply(player).booleanValue()) continue;
            this.viewFunction.accept(player, this.npc.getEntity());
            itr.remove();
        }
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.recalculate();
    }

    public void setAllowlist(Set<UUID> allowlist) {
        this.allowlist = allowlist == null ? null : Sets.newHashSet(allowlist);
    }

    public void setHiddenFrom(Set<UUID> hidden) {
        this.hidden = hidden == null ? null : Sets.newHashSet(hidden);
    }

    public void setPlayerFilter(Function<Player, Boolean> filter) {
        this.filter = filter;
        this.recalculate();
    }

    public void unhide(UUID uuid) {
        if (this.hidden != null) {
            this.hidden.remove(uuid);
        }
        if (this.allowlist != null) {
            this.allowlist.remove(uuid);
        }
        this.hiddenPlayers.add(uuid);
        this.recalculate();
    }

    public void unhideGroup(String group) {
        if (this.groupHidden != null) {
            this.groupHidden.remove(group);
        }
        if (this.groupAllowlist != null) {
            this.groupAllowlist = null;
        }
        this.recalculate();
    }
}

