/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

@TraitName(value="playerfilter")
public class PlayerFilter
extends Trait {
    private final Set<UUID> children = Sets.newHashSet();
    private Function<Player, Boolean> filter;
    @Persist
    private Set<String> groups = null;
    private final Set<UUID> hiddenPlayers = Sets.newHashSet();
    private BiConsumer<Player, Entity> hideFunction;
    @Persist
    private Mode mode = Mode.DENYLIST;
    @Persist
    private Set<UUID> players = null;
    private BiConsumer<Player, Entity> viewFunction;
    private final Set<UUID> viewingPlayers = Sets.newHashSet();

    public PlayerFilter() {
        super("playerfilter");
    }

    public PlayerFilter(BiConsumer<Player, Entity> hideFunction, BiConsumer<Player, Entity> viewFunction) {
        this();
        this.filter = p -> {
            switch (this.mode) {
                case DENYLIST: {
                    if (this.players != null && this.players.contains(p.getUniqueId())) {
                        return true;
                    }
                    if (this.groups == null) break;
                    Permission permission = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
                    if (!this.groups.stream().anyMatch(group -> permission.playerInGroup(p, group))) break;
                    return true;
                }
                case ALLOWLIST: {
                    if (this.players != null && !this.players.contains(p.getUniqueId())) {
                        return true;
                    }
                    if (this.groups == null) break;
                    Permission permission = (Permission)Bukkit.getServicesManager().getRegistration(Permission.class).getProvider();
                    if (this.groups.stream().anyMatch(group -> permission.playerInGroup(p, group))) break;
                    return true;
                }
            }
            return false;
        };
        this.hideFunction = hideFunction;
        this.viewFunction = viewFunction;
    }

    public void addChildNPC(NPC npc) {
        this.children.add(npc.getUniqueId());
    }

    public void addGroup(String group) {
        if (this.groups == null) {
            this.groups = Sets.newHashSet();
        }
        this.groups.add(group);
        this.recalculate();
    }

    public void addPlayer(UUID uuid) {
        if (this.players == null) {
            this.players = Sets.newHashSet();
        }
        this.players.add(uuid);
        this.getSet().add(uuid);
        this.recalculate();
    }

    public boolean affectsGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean affectsPlayer(UUID uuid) {
        return this.players.contains(uuid);
    }

    public void clear() {
        this.players = null;
        this.groups = null;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    private Set<UUID> getInverseSet() {
        return this.mode == Mode.ALLOWLIST ? this.viewingPlayers : this.hiddenPlayers;
    }

    public Set<UUID> getPlayerUUIDs() {
        return this.players;
    }

    private Set<UUID> getSet() {
        return this.mode == Mode.DENYLIST ? this.viewingPlayers : this.hiddenPlayers;
    }

    public boolean isAllowlist() {
        return this.mode == Mode.ALLOWLIST;
    }

    public boolean isDenylist() {
        return this.mode == Mode.DENYLIST;
    }

    public boolean isHidden(Player player) {
        return this.filter == null ? false : this.filter.apply(player);
    }

    @Override
    public void onDespawn() {
        this.hiddenPlayers.clear();
        this.viewingPlayers.clear();
    }

    public boolean onSeenByPlayer(Player player) {
        if (this.isHidden(player)) {
            this.hiddenPlayers.add(player.getUniqueId());
            return true;
        }
        this.viewingPlayers.add(player.getUniqueId());
        return false;
    }

    public void recalculate() {
        Player player;
        UUID uuid;
        Collection npcs = this.children.stream().map(u -> CitizensAPI.getNPCRegistry().getByUniqueIdGlobal((UUID)u)).filter(n -> n != null).collect(Collectors.toList());
        Iterator<UUID> itr = this.viewingPlayers.iterator();
        while (itr.hasNext()) {
            uuid = itr.next();
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                itr.remove();
                continue;
            }
            if (this.hideFunction == null || !this.filter.apply(player).booleanValue()) continue;
            this.hideFunction.accept(player, this.npc.getEntity());
            for (NPC npc : npcs) {
                this.hideFunction.accept(player, npc.getEntity());
            }
            itr.remove();
        }
        itr = this.hiddenPlayers.iterator();
        while (itr.hasNext()) {
            uuid = itr.next();
            player = Bukkit.getPlayer((UUID)uuid);
            if (player == null) {
                itr.remove();
                continue;
            }
            if (this.viewFunction == null || this.filter.apply(player).booleanValue()) continue;
            this.viewFunction.accept(player, this.npc.getEntity());
            for (NPC npc : npcs) {
                this.viewFunction.accept(player, npc.getEntity());
            }
            itr.remove();
        }
    }

    public void removeGroup(String group) {
        if (this.groups != null) {
            this.groups.remove(group);
        }
        this.recalculate();
    }

    public void removePlayer(UUID uuid) {
        if (this.players != null) {
            this.players.remove(uuid);
        }
        this.getInverseSet().add(uuid);
        this.recalculate();
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned() || !this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.recalculate();
    }

    public void setAllowlist() {
        this.mode = Mode.ALLOWLIST;
        this.recalculate();
    }

    public void setDenylist() {
        this.mode = Mode.DENYLIST;
        this.recalculate();
    }

    public void setPlayerFilter(Function<Player, Boolean> filter) {
        this.filter = filter;
        this.recalculate();
    }

    public void setPlayers(Set<UUID> players) {
        this.players = players == null ? null : Sets.newHashSet(players);
    }

    public static enum Mode {
        ALLOWLIST,
        DENYLIST;

    }
}

