/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.LocationLookup;
import net.citizensnpcs.api.NMSHelper;
import net.citizensnpcs.api.ai.speech.SpeechContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.npc.MemoryNPCDataStore;
import net.citizensnpcs.api.npc.NPCDataStore;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.npc.NPCSelector;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitFactory;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class CitizensAPI {
    private static volatile CitizensPlugin instance = null;
    private static ScriptCompiler scriptCompiler;

    private CitizensAPI() {
    }

    public static NPCRegistry createAnonymousNPCRegistry(NPCDataStore store) {
        return CitizensAPI.getImplementation().createAnonymousNPCRegistry(store);
    }

    public static NPCRegistry createCitizensBackedNPCRegistry(NPCDataStore store) {
        return CitizensAPI.getImplementation().createCitizensBackedNPCRegistry(store);
    }

    public static NPCRegistry createInMemoryNPCRegistry(String name) {
        return CitizensAPI.getImplementation().createNamedNPCRegistry(name, new MemoryNPCDataStore());
    }

    public static NPCRegistry createNamedNPCRegistry(String name, NPCDataStore store) {
        return CitizensAPI.getImplementation().createNamedNPCRegistry(name, store);
    }

    public static CommandManager getCommandManager() {
        return CitizensAPI.getImplementation().getCommandManager();
    }

    public static File getDataFolder() {
        return CitizensAPI.getImplementation().getDataFolder();
    }

    public static NPCSelector getDefaultNPCSelector() {
        return CitizensAPI.getImplementation().getDefaultNPCSelector();
    }

    private static CitizensPlugin getImplementation() {
        if (instance == null) {
            throw new IllegalStateException("no implementation set");
        }
        return instance;
    }

    private static ClassLoader getImplementationClassLoader() {
        return CitizensAPI.getImplementation().getOwningClassLoader();
    }

    public static LocationLookup getLocationLookup() {
        return CitizensAPI.getImplementation().getLocationLookup();
    }

    public static NPCRegistry getNamedNPCRegistry(String name) {
        return CitizensAPI.getImplementation().getNamedNPCRegistry(name);
    }

    public static NMSHelper getNMSHelper() {
        return CitizensAPI.getImplementation().getNMSHelper();
    }

    public static Iterable<NPCRegistry> getNPCRegistries() {
        return CitizensAPI.getImplementation().getNPCRegistries();
    }

    public static NPCRegistry getNPCRegistry() {
        return CitizensAPI.getImplementation().getNPCRegistry();
    }

    public static Plugin getPlugin() {
        return CitizensAPI.getImplementation();
    }

    public static ScriptCompiler getScriptCompiler() {
        if (scriptCompiler == null && CitizensAPI.getImplementation() != null) {
            scriptCompiler = new ScriptCompiler(CitizensAPI.getImplementationClassLoader());
        }
        return scriptCompiler;
    }

    public static File getScriptFolder() {
        return CitizensAPI.getImplementation().getScriptFolder();
    }

    public static TraitFactory getTraitFactory() {
        return CitizensAPI.getImplementation().getTraitFactory();
    }

    public static boolean hasImplementation() {
        return instance != null;
    }

    public static void registerEvents(Listener listener) {
        if (Bukkit.getServer() != null && CitizensAPI.getPlugin() != null) {
            Bukkit.getPluginManager().registerEvents(listener, CitizensAPI.getPlugin());
        }
    }

    public static void removeNamedNPCRegistry(String name) {
        CitizensAPI.getImplementation().removeNamedNPCRegistry(name);
    }

    public static void setImplementation(CitizensPlugin implementation) {
        if (implementation != null && CitizensAPI.hasImplementation()) {
            CitizensAPI.getImplementation().onImplementationChanged();
        }
        instance = implementation;
    }

    public static void shutdown() {
        if (scriptCompiler == null) {
            return;
        }
        instance = null;
        scriptCompiler.interrupt();
        scriptCompiler = null;
    }

    public static void talk(SpeechContext context) {
        CitizensAPI.getImplementation().talk(context);
    }
}

