/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.command;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandAnnotationProcessor;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.command.exception.RequirementMissingException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.Messaging;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;

public class RequirementsProcessor
implements CommandAnnotationProcessor {
    @Override
    public Class<? extends Annotation> getAnnotationClass() {
        return Requirements.class;
    }

    @Override
    public void process(CommandSender sender, CommandContext context, Annotation instance, Object[] methodArgs) throws CommandException {
        Requirements requirements = (Requirements)instance;
        NPC npc = methodArgs.length >= 3 && methodArgs[2] instanceof NPC ? (NPC)methodArgs[2] : null;
        boolean canRedefineSelected = (context.hasValueFlag("uuid") || context.hasValueFlag("id")) && sender.hasPermission("npc.select");
        String error = Messaging.tr("citizens.commands.requirements.must-have-selected", new Object[0]);
        if (canRedefineSelected) {
            npc = context.hasValueFlag("uuid") ? CitizensAPI.getNPCRegistry().getByUniqueIdGlobal(UUID.fromString(context.getFlag("uuid"))) : CitizensAPI.getNPCRegistry().getById(context.getFlagInteger("id"));
            if (methodArgs.length >= 3) {
                methodArgs[2] = npc;
            }
            if (npc == null) {
                error = error + ' ' + Messaging.tr("citizens.commands.id-not-found", context.getFlag("id", context.getFlag("uuid")));
            }
        }
        if (requirements.selected() && npc == null) {
            throw new RequirementMissingException(error);
        }
        if (requirements.ownership() && npc != null && !sender.hasPermission("citizens.admin") && !npc.getOrAddTrait(Owner.class).isOwnedBy(sender)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.must-be-owner", new Object[0]));
        }
        if (npc == null) {
            return;
        }
        for (Class<? extends Trait> clazz : requirements.traits()) {
            if (npc.hasTrait(clazz)) continue;
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.missing-required-trait", clazz.getSimpleName()));
        }
        EnumSet<EntityType> types = Sets.newEnumSet(Arrays.asList(requirements.types()), EntityType.class);
        if (types.contains(EntityType.UNKNOWN)) {
            types = EnumSet.allOf(EntityType.class);
        }
        types.removeAll(Sets.newHashSet((Object[])requirements.excludedTypes()));
        EntityType type = npc.getOrAddTrait(MobType.class).getType();
        if (!types.contains(type)) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.disallowed-mobtype", type.name().toLowerCase().replace('_', ' ')));
        }
        if (requirements.livingEntity() && !type.isAlive()) {
            throw new RequirementMissingException(Messaging.tr("citizens.commands.requirements.living-entity", methodArgs));
        }
    }
}

