/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.collect.Maps;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Translator {
    private final Map<String, String> baseTranslations = Translator.getBaseTranslations();
    private final Locale defaultLocale;
    private final Map<String, MessageFormat> messageFormatCache = Maps.newHashMap();
    private final Map<String, String> translations;
    private static Translator INSTANCE;
    private static final Pattern JAPANESE_PATTERN;

    private Translator(File resourceDir, Locale locale) {
        this.defaultLocale = locale;
        this.translations = Translator.getTranslations(resourceDir, locale);
    }

    private String format(String key, Locale locale, Object ... msg) {
        String unreplaced = Translator.translate(key, locale, new Object[0]);
        MessageFormat formatter = this.getFormatter(unreplaced);
        return formatter.format(msg);
    }

    private MessageFormat getFormatter(String unreplaced) {
        MessageFormat formatter = this.messageFormatCache.get(unreplaced);
        if (formatter == null) {
            formatter = new MessageFormat(unreplaced);
            this.messageFormatCache.put(unreplaced, formatter);
        }
        return formatter;
    }

    private String translate(String key) {
        String res = this.translations.computeIfAbsent(key, k -> this.baseTranslations.get(key));
        return res == null ? "?" + key + "?" : res;
    }

    public static String format(String msg, Object ... objects) {
        MessageFormat formatter = INSTANCE.getFormatter(msg);
        return formatter.format(objects);
    }

    private static Map<String, String> getBaseTranslations() {
        JSONObject jSONObject;
        JSONParser jp = new JSONParser();
        InputStreamReader in = new InputStreamReader(Translator.class.getResourceAsStream("/en.json"), StandardCharsets.UTF_8);
        try {
            jSONObject = (JSONObject)jp.parse((Reader)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                return null;
            }
        }
        ((Reader)in).close();
        return jSONObject;
    }

    private static Charset getCharset(String fileName) {
        Charset charset = JAPANESE_PATTERN.matcher(fileName).find() && Charset.isSupported("Shift-JIS") ? Charset.forName("Shift-JIS") : StandardCharsets.UTF_8;
        return charset;
    }

    private static Map<String, String> getTranslations(File resourceDir, Locale locale) {
        JSONObject jSONObject;
        JSONParser jp = new JSONParser();
        InputStream is = null;
        Charset charset = Translator.getCharset(locale.toString() + ".json");
        if (new File(resourceDir, locale.toString() + ".json").exists()) {
            try {
                is = new FileInputStream(new File(resourceDir, locale.toString() + ".json"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else if (new File(resourceDir, locale.getLanguage() + ".json").exists()) {
            try {
                is = new FileInputStream(new File(resourceDir, locale.getLanguage() + ".json"));
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            is = Translator.class.getResourceAsStream("/" + locale.getLanguage() + ".json");
            if (is != null) {
                if (!locale.getLanguage().equals("en")) {
                    new Thread(new SaveResource(resourceDir, locale.getLanguage() + ".json")).start();
                }
            } else {
                is = Translator.class.getResourceAsStream("/" + locale.toString() + ".json");
                if (is != null && !locale.getLanguage().equals("en")) {
                    new Thread(new SaveResource(resourceDir, locale.toString() + ".json")).start();
                }
            }
        }
        InputStreamReader in = new InputStreamReader(is, charset);
        try {
            jSONObject = (JSONObject)jp.parse((Reader)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                return Maps.newHashMap();
            }
        }
        ((Reader)in).close();
        return jSONObject;
    }

    public static void setInstance(File dataFolder, Locale preferredLocale) {
        INSTANCE = new Translator(dataFolder, preferredLocale);
    }

    private static String translate(String key, Locale preferredLocale, Object ... msg) {
        return msg.length == 0 ? INSTANCE.translate(key) : INSTANCE.format(key, preferredLocale, msg);
    }

    public static String translate(String key, Object ... msg) {
        return Translator.translate(key, Translator.INSTANCE.defaultLocale, msg);
    }

    static {
        JAPANESE_PATTERN = Pattern.compile(".*?ja(_jp)?\\.json", 2);
    }

    private static class SaveResource
    implements Runnable {
        private final String fileName;
        private final File rootFolder;

        private SaveResource(File rootFolder, String fileName) {
            this.rootFolder = rootFolder;
            this.fileName = fileName;
        }

        @Override
        public void run() {
            File file = new File(this.rootFolder, this.fileName);
            if (file.exists()) {
                return;
            }
            try {
                this.rootFolder.mkdirs();
                File to = File.createTempFile(this.fileName, null, this.rootFolder);
                to.deleteOnExit();
                Resources.asByteSource((URL)Resources.getResource(Translator.class, (String)('/' + this.fileName))).copyTo(Files.asByteSink((File)to, (FileWriteMode[])new FileWriteMode[0]));
                if (!file.exists()) {
                    to.renameTo(file);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

